/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.net4j.util.Predicate;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EMFUtil {
    public static final String CDO_ANNOTATION_SOURCE = "http://www.eclipse.org/emf/CDO";
    public static final String CDO_ANNOTATION_KEY_PERSISTENT = "persistent";
    public static final EReference EOPERATION_EEXCEPTIONS = EcorePackage.eINSTANCE.getEOperation_EExceptions();
    public static final EReference ETYPED_ELEMENT_ETYPE = EcorePackage.eINSTANCE.getETypedElement_EType();
    public static final EReference ECLASS_ESUPER_TYPES = EcorePackage.eINSTANCE.getEClass_ESuperTypes();
    public static final EAttribute ECLASSIFIER_INSTANCE_CLASS_NAME = EcorePackage.eINSTANCE.getEClassifier_InstanceClassName();
    public static final EReference EOPERATION_EGENERIC_EXCEPTIONS = EcorePackage.eINSTANCE.getEOperation_EGenericExceptions();
    public static final EReference ETYPED_ELEMENT_EGENERIC_TYPE = EcorePackage.eINSTANCE.getETypedElement_EGenericType();
    public static final EReference ECLASS_EGENERIC_SUPER_TYPES = EcorePackage.eINSTANCE.getEClass_EGenericSuperTypes();
    public static final EAttribute ECLASSIFIER_INSTANCE_TYPE_NAME = EcorePackage.eINSTANCE.getEClassifier_InstanceTypeName();
    public static final Predicate<EStructuralFeature> ATTRIBUTES = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature feature) {
            return feature instanceof EAttribute;
        }
    };
    public static final Predicate<EStructuralFeature> REFERENCES = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature feature) {
            return feature instanceof EReference;
        }
    };
    public static final Predicate<EStructuralFeature> CONTAINER_REFERENCES = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature feature) {
            if (feature instanceof EReference) {
                EReference reference = (EReference)feature;
                return reference.isContainer();
            }
            return false;
        }
    };
    public static final Predicate<EStructuralFeature> CROSS_REFERENCES = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature feature) {
            if (feature instanceof EReference) {
                EReference reference = (EReference)feature;
                return !reference.isContainer() && !reference.isContainment();
            }
            return false;
        }
    };
    public static final Predicate<EStructuralFeature> CONTAINMENT_REFERENCES = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature feature) {
            if (feature instanceof EReference) {
                EReference reference = (EReference)feature;
                return reference.isContainment();
            }
            return false;
        }
    };

    private EMFUtil() {
    }

    public static URI getPositionalURI(InternalEObject internalEObject) {
        Resource.Internal resource;
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        InternalEObject container = internalEObject.eInternalContainer();
        while ((resource = internalEObject.eDirectResource()) == null && container != null) {
            String segment = EMFUtil.getPositionalURIFragmentSegment((EObject)container, internalEObject.eContainingFeature(), internalEObject);
            uriFragmentPath.add(segment);
            internalEObject = container;
            container = internalEObject.eInternalContainer();
        }
        StringBuilder builder = new StringBuilder("/");
        builder.append(resource.getContents().indexOf((Object)internalEObject));
        int i = uriFragmentPath.size() - 1;
        while (i >= 0) {
            builder.append('/');
            builder.append((String)uriFragmentPath.get(i));
            --i;
        }
        return resource.getURI().appendFragment(builder.toString());
    }

    private static String getPositionalURIFragmentSegment(EObject container, EStructuralFeature eStructuralFeature, InternalEObject eObject) {
        StringBuilder builder = new StringBuilder();
        builder.append('@');
        builder.append(eStructuralFeature.getName());
        if (eStructuralFeature instanceof EAttribute) {
            FeatureMap featureMap = (FeatureMap)container.eGet(eStructuralFeature, false);
            int i = 0;
            int size = featureMap.size();
            while (i < size) {
                EStructuralFeature entryFeature;
                if (featureMap.getValue(i) == eObject && (entryFeature = featureMap.getEStructuralFeature(i)) instanceof EReference && ((EReference)entryFeature).isContainment()) {
                    builder.append('.');
                    builder.append(i);
                    return builder.toString();
                }
                ++i;
            }
            builder.append(".-1");
        } else if (eStructuralFeature.isMany()) {
            EList eList = (EList)container.eGet(eStructuralFeature, false);
            int index = eList.indexOf((Object)eObject);
            builder.append('.');
            builder.append(index);
        }
        return builder.toString();
    }

    public static EPackage getGeneratedEPackage(EPackage ePackage) {
        String packageURI = ePackage.getNsURI();
        if (packageURI.equals(EcorePackage.eINSTANCE.getNsURI())) {
            return EcorePackage.eINSTANCE;
        }
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        return registry.getEPackage(packageURI);
    }

    public static Map.Entry<String, Object>[] getSortedRegistryEntries(EPackage.Registry packageRegistry) {
        Set entries = packageRegistry.entrySet();
        Map.Entry[] array = entries.toArray(new Map.Entry[entries.size()]);
        Arrays.sort(array, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return array;
    }

    public static EList<EAnnotation> getAnnotations(EClass eClass, String sourceURI) {
        BasicEList annotations = new BasicEList();
        EMFUtil.getAnnotations(eClass, sourceURI, (EList<EAnnotation>)annotations, new HashSet<EClass>());
        return annotations;
    }

    private static void getAnnotations(EClass eClass, String sourceURI, EList<EAnnotation> annotations, Set<EClass> visited) {
        if (visited.add(eClass)) {
            for (EAnnotation annotation : eClass.getEAnnotations()) {
                if (sourceURI != null && !sourceURI.equals(annotation.getSource())) continue;
                annotations.add((Object)annotation);
            }
            for (EClass superType : eClass.getESuperTypes()) {
                EMFUtil.getAnnotations(superType, sourceURI, annotations, visited);
            }
        }
    }

    public static EPackage getTopLevelPackage(EPackage ePackage) {
        EPackage superPackage = ePackage.getESuperPackage();
        return superPackage == null ? ePackage : EMFUtil.getTopLevelPackage(superPackage);
    }

    public static EPackage createEPackage(String name, String nsPrefix, String nsURI) {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName(name);
        ePackage.setNsPrefix(nsPrefix);
        ePackage.setNsURI(nsURI);
        return ePackage;
    }

    public static EClass createEClass(EPackage ePackage, String name, boolean isAbstract, boolean isInterface) {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(name);
        eClass.setAbstract(isAbstract);
        eClass.setInterface(isInterface);
        ePackage.getEClassifiers().add((Object)eClass);
        return eClass;
    }

    public static EAttribute createEAttribute(EClass eClass, String name, EClassifier type) {
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName(name);
        eAttribute.setEType(type);
        eClass.getEStructuralFeatures().add((Object)eAttribute);
        return eAttribute;
    }

    public static EReference createEReference(EClass eClass, String name, EClassifier type, boolean isRequired, boolean isMany) {
        EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        eReference.setName(name);
        eReference.setEType(type);
        eReference.setLowerBound(isRequired ? 1 : 0);
        eReference.setUpperBound(isMany ? -1 : 0);
        eClass.getEStructuralFeatures().add((Object)eReference);
        return eReference;
    }

    public static EClass[] getConcreteClasses(EPackage ePackage) {
        ArrayList<EClass> result = new ArrayList<EClass>(0);
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            EClass eClass;
            if (!(classifier instanceof EClass) || (eClass = (EClass)classifier).isAbstract() || eClass.isInterface()) continue;
            result.add(eClass);
        }
        return result.toArray(new EClass[result.size()]);
    }

    public static EClass[] getPersistentClasses(EPackage ePackage) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            result.add((EClass)classifier);
        }
        return result.toArray(new EClass[result.size()]);
    }

    @Deprecated
    public static List<EStructuralFeature> getPersistentFeatures(EList<EStructuralFeature> eFeatures) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature feature : eFeatures) {
            if (!EMFUtil.isPersistent(feature)) continue;
            result.add(feature);
        }
        return result;
    }

    public static boolean isPersistent(EStructuralFeature feature) {
        if (feature == ECLASS_ESUPER_TYPES || feature == ETYPED_ELEMENT_ETYPE || feature == EOPERATION_EEXCEPTIONS || feature == ECLASSIFIER_INSTANCE_CLASS_NAME) {
            return false;
        }
        String persistent = EcoreUtil.getAnnotation((EModelElement)feature, (String)CDO_ANNOTATION_SOURCE, (String)CDO_ANNOTATION_KEY_PERSISTENT);
        if (persistent != null) {
            return "true".equalsIgnoreCase(persistent);
        }
        if (feature.isTransient()) {
            EReference eOpposite;
            return feature instanceof EReference && (eOpposite = ((EReference)feature).getEOpposite()) != null && !eOpposite.isTransient();
        }
        return true;
    }

    public static boolean isDynamicEPackage(Object value) {
        return value.getClass() == EPackageImpl.class;
    }

    public static String getParentURI(EPackage ePackage) {
        EPackage superPackage = ePackage.getESuperPackage();
        String parentURI = superPackage == null ? null : superPackage.getNsURI();
        return parentURI;
    }

    public static void registerPackage(EPackage ePackage, EPackage.Registry ... packageRegistries) {
        ePackage.getClass();
        if (packageRegistries == null || packageRegistries.length == 0) {
            EPackage.Registry[] globalRegistry = new EPackage.Registry[]{EPackage.Registry.INSTANCE};
            packageRegistries = globalRegistry;
        }
        EPackage.Registry[] registryArray = packageRegistries;
        int n = packageRegistries.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage.Registry packageRegistry = registryArray[n2];
            packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
            ++n2;
        }
    }

    public static byte[] getEPackageBytes(EPackage ePackage, boolean zipped, EPackage.Registry packageRegistry) {
        try {
            Resource.Internal resource = ((InternalEObject)ePackage).eDirectResource();
            if (resource == null) {
                ResourceSet resourceSet = EMFUtil.newEcoreResourceSet(packageRegistry);
                resource = resourceSet.createResource(URI.createURI((String)ePackage.getNsURI()));
                resource.getContents().add((Object)(ePackage.eContainer() == null ? ePackage : (EPackage)EcoreUtil.copy((EObject)ePackage)));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            resource.save((OutputStream)baos, EMFUtil.createResourceOptions(zipped));
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public static EPackage createEPackage(String uri, byte[] bytes, boolean zipped, ResourceSet resourceSet, boolean lookForResource) {
        try {
            Resource resource = null;
            if (lookForResource) {
                resource = resourceSet.getResource(URI.createURI((String)uri), true);
            }
            if (resource == null) {
                resource = resourceSet.createResource(URI.createURI((String)uri));
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            resource.load((InputStream)bais, EMFUtil.createResourceOptions(zipped));
            EList contents = resource.getContents();
            return (EPackage)contents.get(0);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    private static Map<String, Object> createResourceOptions(boolean zipped) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (zipped) {
            options.put("ZIP", true);
        }
        return options;
    }

    public static <T> T getAdapter(Notifier notifier, Class<T> type) {
        Adapter adapter = EcoreUtil.getAdapter((List)notifier.eAdapters(), type);
        return (T)adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdapter(Notifier notifier, Adapter adapter) {
        Notifier notifier2 = notifier;
        synchronized (notifier2) {
            EList adapters = notifier.eAdapters();
            if (!adapters.contains((Object)adapter)) {
                adapters.add((Object)adapter);
            }
        }
    }

    public static EPackage[] getAllPackages(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EMFUtil.getAllPackages(ePackage, result);
        return result.toArray(new EPackage[result.size()]);
    }

    private static void getAllPackages(EPackage ePackage, List<EPackage> result) {
        result.add(ePackage);
        for (EPackage subPackage : ePackage.getESubpackages()) {
            EMFUtil.getAllPackages(subPackage, result);
        }
    }

    public static String getQualifiedName(EPackage ePackage, String separator) {
        StringBuilder builder = new StringBuilder();
        EPackage eSuperPackage = ePackage.getESuperPackage();
        if (eSuperPackage != null) {
            builder.append(EMFUtil.getQualifiedName(eSuperPackage, separator));
            builder.append(separator);
        }
        builder.append(ePackage.getName());
        return builder.toString();
    }

    public static String getQualifiedName(EClassifier classifier, String separator) {
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = classifier.getEPackage();
        if (ePackage != null) {
            builder.append(EMFUtil.getQualifiedName(ePackage, separator));
            builder.append(separator);
        }
        builder.append(classifier.getName());
        return builder.toString();
    }

    public static ResourceSet newResourceSet(Resource.Factory resourceFactory) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        return resourceSet;
    }

    public static ResourceSet newEcoreResourceSet(EPackage.Registry packageRegistry) {
        ResourceSet resourceSet = EMFUtil.newResourceSet((Resource.Factory)new EcoreResourceFactoryImpl());
        resourceSet.setPackageRegistry(packageRegistry);
        return resourceSet;
    }

    public static ResourceSet newEcoreResourceSet() {
        return EMFUtil.newEcoreResourceSet(EPackage.Registry.INSTANCE);
    }

    public static EObject safeResolve(EObject proxy, ResourceSet resourceSet) {
        if (!proxy.eIsProxy()) {
            return proxy;
        }
        EObject resolved = EcoreUtil.resolve((EObject)proxy, (ResourceSet)resourceSet);
        if (resolved == proxy) {
            throw new IllegalStateException("Unresolvable proxy: " + ((InternalEObject)proxy).eProxyURI());
        }
        return resolved;
    }

    public static void safeResolveAll(ResourceSet resourceSet) {
        TreeIterator it = resourceSet.getAllContents();
        while (it.hasNext()) {
            Notifier notifier = (Notifier)it.next();
            if (!(notifier instanceof EObject)) continue;
            EMFUtil.safeResolve((EObject)notifier, resourceSet);
            if (notifier instanceof EAnnotation) {
                it.prune();
                continue;
            }
            Iterator it2 = ((EObject)notifier).eCrossReferences().iterator();
            while (it2.hasNext()) {
                EMFUtil.safeResolve((EObject)it2.next(), resourceSet);
            }
        }
    }

    public static ExtResourceSet createExtResourceSet(InternalCDOPackageRegistry packageRegistry, boolean delegating, boolean demandLoading) {
        EcoreResourceFactoryImpl resourceFactory = new EcoreResourceFactoryImpl();
        ExtResourceSet resourceSet = new ExtResourceSet(delegating, demandLoading);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        resourceSet.setPackageRegistry(packageRegistry);
        return resourceSet;
    }

    public static class ExtResourceSet
    extends ResourceSetImpl {
        private boolean delegating;
        private boolean demandLoading;

        ExtResourceSet(boolean delegating, boolean demandLoading) {
            this.delegating = delegating;
            this.demandLoading = demandLoading;
        }

        public boolean isDelegating() {
            return this.delegating;
        }

        public void setDelegating(boolean delegating) {
            this.delegating = delegating;
        }

        public boolean isDemandLoading() {
            return this.demandLoading;
        }

        public void setDemandLoading(boolean demandLoading) {
            this.demandLoading = demandLoading;
        }

        protected void demandLoad(Resource resource) throws IOException {
            if (this.demandLoading) {
                super.demandLoad(resource);
            }
        }

        protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
            if (this.delegating) {
                return super.delegatedGetResource(uri, loadOnDemand);
            }
            return null;
        }
    }
}

