/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOAllRevisionsProvider;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.CommitInfoTable;
import org.eclipse.emf.cdo.server.internal.db.DBStoreAccessor;
import org.eclipse.emf.cdo.server.internal.db.DurableLockingManager;
import org.eclipse.emf.cdo.server.internal.db.LongIDHandler;
import org.eclipse.emf.cdo.server.internal.db.MetaDataManager;
import org.eclipse.emf.cdo.server.internal.db.UUIDHandler;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.IMappingConstants;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.UnitMappingTable;
import org.eclipse.emf.cdo.server.internal.db.messages.Messages;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.LongIDStoreAccessor;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStore
extends Store
implements IDBStore,
IMappingConstants,
CDOAllRevisionsProvider {
    public static final String TYPE = "db";
    public static final int SCHEMA_VERSION = 4;
    private static final int FIRST_START = -1;
    private static final String PROP_SCHEMA_VERSION = "org.eclipse.emf.cdo.server.db.schemaVersion";
    private static final String PROP_REPOSITORY_CREATED = "org.eclipse.emf.cdo.server.db.repositoryCreated";
    private static final String PROP_REPOSITORY_STOPPED = "org.eclipse.emf.cdo.server.db.repositoryStopped";
    private static final String PROP_NEXT_LOCAL_CDOID = "org.eclipse.emf.cdo.server.db.nextLocalCDOID";
    private static final String PROP_LAST_CDOID = "org.eclipse.emf.cdo.server.db.lastCDOID";
    private static final String PROP_LAST_BRANCHID = "org.eclipse.emf.cdo.server.db.lastBranchID";
    private static final String PROP_LAST_LOCAL_BRANCHID = "org.eclipse.emf.cdo.server.db.lastLocalBranchID";
    private static final String PROP_LAST_COMMITTIME = "org.eclipse.emf.cdo.server.db.lastCommitTime";
    private static final String PROP_LAST_NONLOCAL_COMMITTIME = "org.eclipse.emf.cdo.server.db.lastNonLocalCommitTime";
    private static final String PROP_GRACEFULLY_SHUT_DOWN = "org.eclipse.emf.cdo.server.db.gracefullyShutDown";
    private long creationTime;
    private boolean firstTime;
    private Map<String, String> properties;
    private int idColumnLength = -1;
    private int jdbcFetchSize = 100000;
    private IIDHandler idHandler;
    private IMetaDataManager metaDataManager = new MetaDataManager(this);
    private DurableLockingManager durableLockingManager = new DurableLockingManager(this);
    private CommitInfoTable commitInfoTable;
    private UnitMappingTable unitMappingTable;
    private IMappingStrategy mappingStrategy;
    private IDBDatabase database;
    private IDBAdapter dbAdapter;
    private IDBConnectionProvider dbConnectionProvider;
    @ReflectUtil.ExcludeFromDump
    private transient ProgressDistributor accessorWriteDistributor = new ProgressDistributor.Geometric(){

        public String toString() {
            String result = "accessorWriteDistributor";
            if (DBStore.this.getRepository() != null) {
                result = String.valueOf(result) + ": " + DBStore.this.getRepository().getName();
            }
            return result;
        }
    };
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool readerPool = new StoreAccessorPool((IStore)this, null);
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool writerPool = new StoreAccessorPool((IStore)this, null);
    @ReflectUtil.ExcludeFromDump
    private transient Timer connectionKeepAliveTimer;
    private static final int FIRST_VERSION_WITH_NULLABLE_CHECKS = 4;
    private static final SchemaMigrator NO_MIGRATION_NEEDED = null;
    private static final SchemaMigrator NON_AUDIT_MIGRATION = new SchemaMigrator(){

        public void migrateSchema(DBStore store, Connection connection) throws Exception {
            InternalRepository repository = store.getRepository();
            if (!repository.isSupportingAudits()) {
                store.visitAllTables(connection, new IDBStore.TableVisitor(){

                    public void visitTable(Connection connection, String name) throws SQLException {
                        Statement statement = null;
                        try {
                            statement = connection.createStatement();
                            String from = " FROM " + name + " WHERE " + "CDO_VERSION" + "<" + 1;
                            statement.executeUpdate("DELETE FROM " + CDODBSchema.CDO_OBJECTS + " WHERE " + "CDO_ID" + " IN (SELECT " + "CDO_ID" + from + ")");
                            statement.executeUpdate("DELETE" + from);
                        }
                        finally {
                            DBUtil.close((Statement)statement);
                        }
                    }
                });
            }
        }
    };
    private static final SchemaMigrator LOB_SIZE_MIGRATION = new SchemaMigrator(){

        public void migrateSchema(DBStore store, Connection connection) throws Exception {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                IDBAdapter dbAdapter = store.getDBAdapter();
                String sql = dbAdapter.sqlRenameField(CDODBSchema.LOBS_SIZE, "size");
                statement.execute(sql);
            }
            finally {
                DBUtil.close((Statement)statement);
            }
        }
    };
    private static final SchemaMigrator NULLABLE_COLUMNS_MIGRATION = null;
    private static final SchemaMigrator[] SCHEMA_MIGRATORS = new SchemaMigrator[]{NO_MIGRATION_NEEDED, NON_AUDIT_MIGRATION, LOB_SIZE_MIGRATION, NULLABLE_COLUMNS_MIGRATION};

    static {
        if (SCHEMA_MIGRATORS.length != 4) {
            throw new Error("There must be exactly 4 schema migrators provided");
        }
    }

    public DBStore() {
        super(TYPE, null, DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION, IStore.ChangeFormat.DELTA}), DBStore.set((Object[])new IStore.RevisionTemporality[]{IStore.RevisionTemporality.AUDITING, IStore.RevisionTemporality.NONE}), DBStore.set((Object[])new IStore.RevisionParallelism[]{IStore.RevisionParallelism.NONE, IStore.RevisionParallelism.BRANCHING}));
    }

    @Override
    public IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(IMappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
        mappingStrategy.setStore(this);
    }

    @Override
    public IDBAdapter getDBAdapter() {
        return this.dbAdapter;
    }

    public void setDBAdapter(IDBAdapter dbAdapter) {
        this.dbAdapter = dbAdapter;
    }

    public void setProperties(Map<String, String> properties) {
        this.checkInactive();
        this.properties = properties;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public int getJDBCFetchSize() {
        return this.jdbcFetchSize;
    }

    @Override
    public int getIDColumnLength() {
        return this.idColumnLength;
    }

    @Override
    public IIDHandler getIDHandler() {
        return this.idHandler;
    }

    @Override
    public IDBDatabase getDatabase() {
        return this.database;
    }

    public Connection getConnection() {
        Connection connection = this.dbConnectionProvider.getConnection();
        if (connection == null) {
            throw new DBException("No connection from connection provider: " + this.dbConnectionProvider);
        }
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex, "SET AUTO COMMIT = false");
        }
        return connection;
    }

    public void setDBConnectionProvider(IDBConnectionProvider dbConnectionProvider) {
        this.dbConnectionProvider = dbConnectionProvider;
    }

    @Override
    public IMetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public DurableLockingManager getDurableLockingManager() {
        return this.durableLockingManager;
    }

    public CommitInfoTable getCommitInfoTable() {
        return this.commitInfoTable;
    }

    public UnitMappingTable getUnitMappingTable() {
        return this.unitMappingTable;
    }

    public Timer getConnectionKeepAliveTimer() {
        return this.connectionKeepAliveTimer;
    }

    public Set<IStore.ChangeFormat> getSupportedChangeFormats() {
        if (this.mappingStrategy.hasDeltaSupport()) {
            return DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.DELTA});
        }
        return DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION});
    }

    public ProgressDistributor getAccessorWriteDistributor() {
        return this.accessorWriteDistributor;
    }

    @Override
    public IDBSchema getDBSchema() {
        return this.database.getSchema();
    }

    @Override
    public void visitAllTables(Connection connection, IDBStore.TableVisitor visitor) {
        for (String name : DBUtil.getAllTableNames((Connection)connection, (String)this.getRepository().getName())) {
            try {
                visitor.visitTable(connection, name);
                connection.commit();
            }
            catch (SQLException ex) {
                try {
                    connection.rollback();
                }
                catch (SQLException ex1) {
                    throw new DBException((Throwable)ex1);
                }
                if (this.dbAdapter.isColumnNotFoundException(ex)) continue;
                throw new DBException((Throwable)ex);
            }
        }
    }

    public Map<String, String> getPersistentProperties(Set<String> names) {
        HashMap<String, String> hashMap;
        IDBConnection connection = this.database.getConnection();
        IDBPreparedStatement stmt = null;
        String sql = null;
        try {
            boolean allProperties;
            HashMap<String, String> result = new HashMap<String, String>();
            boolean bl = allProperties = names == null || names.isEmpty();
            if (allProperties) {
                sql = CDODBSchema.SQL_SELECT_ALL_PROPERTIES;
                stmt = connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
                IDBResultSet resultSet = null;
                try {
                    resultSet = stmt.executeQuery();
                    while (resultSet.next()) {
                        String key = resultSet.getString(1);
                        String value = resultSet.getString(2);
                        result.put(key, value);
                    }
                }
                finally {
                    DBUtil.close((ResultSet)resultSet);
                }
            } else {
                sql = CDODBSchema.SQL_SELECT_PROPERTIES;
                stmt = connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
                for (String name : names) {
                    stmt.setString(1, name);
                    IDBResultSet resultSet = null;
                    try {
                        resultSet = stmt.executeQuery();
                        if (!resultSet.next()) continue;
                        String value = resultSet.getString(1);
                        result.put(name, value);
                    }
                    finally {
                        DBUtil.close((ResultSet)resultSet);
                    }
                }
            }
            hashMap = result;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex, sql);
            }
            catch (Throwable throwable) {
                DBUtil.close(stmt);
                DBUtil.close((Connection)connection);
                throw throwable;
            }
        }
        DBUtil.close((Statement)stmt);
        DBUtil.close((Connection)connection);
        return hashMap;
    }

    public void setPersistentProperties(Map<String, String> properties) {
        IDBConnection connection = this.database.getConnection();
        IDBPreparedStatement deleteStmt = connection.prepareStatement(CDODBSchema.SQL_DELETE_PROPERTIES, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBPreparedStatement insertStmt = connection.prepareStatement(CDODBSchema.SQL_INSERT_PROPERTIES, IDBPreparedStatement.ReuseProbability.MEDIUM);
        String sql = null;
        try {
            try {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    sql = CDODBSchema.SQL_DELETE_PROPERTIES;
                    deleteStmt.setString(1, name);
                    deleteStmt.executeUpdate();
                    sql = CDODBSchema.SQL_INSERT_PROPERTIES;
                    insertStmt.setString(1, name);
                    insertStmt.setString(2, value);
                    insertStmt.executeUpdate();
                }
                sql = null;
                connection.commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex, sql);
            }
        }
        finally {
            DBUtil.close((Statement)insertStmt);
            DBUtil.close((Statement)deleteStmt);
            DBUtil.close((Connection)connection);
        }
    }

    public void putPersistentProperty(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        this.setPersistentProperties(map);
    }

    public void removePersistentProperties(Set<String> names) {
        IDBConnection connection = this.database.getConnection();
        IDBPreparedStatement stmt = connection.prepareStatement(CDODBSchema.SQL_DELETE_PROPERTIES, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            try {
                for (String name : names) {
                    stmt.setString(1, name);
                    stmt.executeUpdate();
                }
                connection.commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex, CDODBSchema.SQL_DELETE_PROPERTIES);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
            DBUtil.close((Connection)connection);
        }
    }

    @Override
    public DBStoreAccessor getReader(ISession session) {
        return (DBStoreAccessor)super.getReader(session);
    }

    @Override
    public DBStoreAccessor getWriter(ITransaction transaction) {
        return (DBStoreAccessor)super.getWriter(transaction);
    }

    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return this.readerPool;
    }

    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return this.writerPool;
    }

    protected DBStoreAccessor createReader(ISession session) throws DBException {
        return new DBStoreAccessor(this, session);
    }

    protected DBStoreAccessor createWriter(ITransaction transaction) throws DBException {
        return new DBStoreAccessor(this, transaction);
    }

    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        final HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        InternalSession session = null;
        if (!StoreThreadLocal.hasSession()) {
            session = this.getRepository().getSessionManager().openSession(null);
            StoreThreadLocal.setSession((InternalSession)session);
        }
        try {
            StoreThreadLocal.getAccessor().handleRevisions(null, null, 0L, true, (CDORevisionHandler)new CDORevisionHandler.Filtered.Undetached(new CDORevisionHandler(){

                public boolean handleRevision(CDORevision revision) {
                    CDOBranch branch = revision.getBranch();
                    ArrayList<CDORevision> list = (ArrayList<CDORevision>)result.get(branch);
                    if (list == null) {
                        list = new ArrayList<CDORevision>();
                        result.put(branch, list);
                    }
                    list.add(revision);
                    return true;
                }
            }));
        }
        finally {
            if (session != null) {
                StoreThreadLocal.release();
                session.close();
            }
        }
        return result;
    }

    public CDOID createObjectID(String val) {
        return this.idHandler.createCDOID(val);
    }

    @Deprecated
    public boolean isLocal(CDOID id) {
        throw new UnsupportedOperationException();
    }

    public CDOID getNextCDOID(LongIDStoreAccessor accessor, CDORevision revision) {
        return this.idHandler.getNextCDOID(revision);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_REPOSITORY_CREATED, Long.toString(creationTime));
        this.setPersistentProperties(map);
    }

    public boolean isFirstStart() {
        return this.firstTime;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkNull(this.mappingStrategy, Messages.getString("DBStore.2"));
        this.checkNull(this.dbAdapter, Messages.getString("DBStore.1"));
        this.checkNull(this.dbConnectionProvider, Messages.getString("DBStore.0"));
    }

    protected void doActivate() throws Exception {
        int schemaVersion;
        super.doActivate();
        InternalRepository repository = this.getRepository();
        CDOCommonRepository.IDGenerationLocation idGenerationLocation = repository.getIDGenerationLocation();
        this.idHandler = idGenerationLocation == CDOCommonRepository.IDGenerationLocation.CLIENT ? new UUIDHandler(this) : new LongIDHandler(this);
        this.setObjectIDTypes(this.idHandler.getObjectIDTypes());
        this.connectionKeepAliveTimer = new Timer("Connection-Keep-Alive-" + this);
        if (this.properties != null) {
            String prop;
            if (idGenerationLocation == CDOCommonRepository.IDGenerationLocation.CLIENT && (prop = this.properties.get("idColumnLength")) != null) {
                this.idColumnLength = Integer.parseInt(prop);
            }
            this.configureAccessorPool(this.readerPool, "readerPoolCapacity");
            this.configureAccessorPool(this.writerPool, "writerPoolCapacity");
            prop = this.properties.get("dropAllDataOnActivate");
            if (prop != null) {
                this.setDropAllDataOnActivate(Boolean.parseBoolean(prop));
            }
            if ((prop = this.properties.get("jdbcFetchSize")) != null) {
                this.jdbcFetchSize = Integer.parseInt(prop);
            }
        }
        Connection connection = this.getConnection();
        try {
            if (this.isDropAllDataOnActivate()) {
                OM.LOG.info("Dropping all tables from repository " + repository.getName() + "...");
                DBUtil.dropAllTables((Connection)connection, null);
                connection.commit();
            }
            if ((schemaVersion = this.selectSchemaVersion(connection)) >= 0 && schemaVersion < 4) {
                this.migrateSchema(schemaVersion);
            }
            connection.commit();
        }
        finally {
            DBUtil.close((Connection)connection);
        }
        String schemaName = repository.getName();
        boolean fixNullableIndexColumns = schemaVersion != -1 && schemaVersion < 4;
        this.database = DBUtil.openDatabase((IDBAdapter)this.dbAdapter, (IDBConnectionProvider)this.dbConnectionProvider, (String)schemaName, (boolean)fixNullableIndexColumns);
        IDBSchemaTransaction schemaTransaction = this.database.openSchemaTransaction();
        try {
            schemaTransaction.ensureSchema(CDODBSchema.INSTANCE);
            schemaTransaction.commit();
        }
        finally {
            schemaTransaction.close();
        }
        LifecycleUtil.activate((Object)this.idHandler);
        LifecycleUtil.activate((Object)this.metaDataManager);
        LifecycleUtil.activate((Object)((Object)this.durableLockingManager));
        LifecycleUtil.activate((Object)this.mappingStrategy);
        if (repository.getCommitInfoStorage() != CDOCommonRepository.CommitInfoStorage.NO) {
            this.commitInfoTable = new CommitInfoTable(this);
            this.commitInfoTable.activate();
        }
        if (repository.isSupportingUnits()) {
            this.unitMappingTable = new UnitMappingTable(this.mappingStrategy);
            this.unitMappingTable.activate();
        }
        this.setRevisionTemporality(this.mappingStrategy.hasAuditSupport() ? IStore.RevisionTemporality.AUDITING : IStore.RevisionTemporality.NONE);
        this.setRevisionParallelism(this.mappingStrategy.hasBranchingSupport() ? IStore.RevisionParallelism.BRANCHING : IStore.RevisionParallelism.NONE);
        if (schemaVersion == -1) {
            this.firstStart();
        } else {
            this.reStart();
        }
        this.putPersistentProperty(PROP_SCHEMA_VERSION, Integer.toString(4));
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.unitMappingTable);
        LifecycleUtil.deactivate((Object)((Object)this.commitInfoTable));
        LifecycleUtil.deactivate((Object)this.mappingStrategy);
        LifecycleUtil.deactivate((Object)((Object)this.durableLockingManager));
        LifecycleUtil.deactivate((Object)this.metaDataManager);
        LifecycleUtil.deactivate((Object)this.idHandler);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_GRACEFULLY_SHUT_DOWN, Boolean.TRUE.toString());
        map.put(PROP_REPOSITORY_STOPPED, Long.toString(this.getRepository().getTimeStamp()));
        if (this.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            map.put(PROP_NEXT_LOCAL_CDOID, Store.idToString((CDOID)this.idHandler.getNextLocalObjectID()));
            map.put(PROP_LAST_CDOID, Store.idToString((CDOID)this.idHandler.getLastObjectID()));
        }
        map.put(PROP_LAST_BRANCHID, Integer.toString(this.getLastBranchID()));
        map.put(PROP_LAST_LOCAL_BRANCHID, Integer.toString(this.getLastLocalBranchID()));
        map.put(PROP_LAST_COMMITTIME, Long.toString(this.getLastCommitTime()));
        map.put(PROP_LAST_NONLOCAL_COMMITTIME, Long.toString(this.getLastNonLocalCommitTime()));
        this.setPersistentProperties(map);
        if (this.readerPool != null) {
            this.readerPool.dispose();
        }
        if (this.writerPool != null) {
            this.writerPool.dispose();
        }
        this.connectionKeepAliveTimer.cancel();
        this.connectionKeepAliveTimer = null;
        super.doDeactivate();
    }

    protected boolean isFirstStart(Set<IDBTable> createdTables) {
        if (createdTables.contains(CDODBSchema.PROPERTIES)) {
            return true;
        }
        HashSet<String> names = new HashSet<String>();
        names.add(PROP_REPOSITORY_CREATED);
        Map<String, String> map = this.getPersistentProperties(names);
        return map.get(PROP_REPOSITORY_CREATED) == null;
    }

    protected void firstStart() {
        InternalRepository repository = this.getRepository();
        this.setCreationTime(repository.getTimeStamp());
        this.firstTime = true;
    }

    protected void reStart() throws Exception {
        HashSet<String> names = new HashSet<String>();
        names.add(PROP_REPOSITORY_CREATED);
        names.add(PROP_GRACEFULLY_SHUT_DOWN);
        Map<String, String> map = this.getPersistentProperties(names);
        this.creationTime = Long.valueOf(map.get(PROP_REPOSITORY_CREATED));
        if (map.containsKey(PROP_GRACEFULLY_SHUT_DOWN)) {
            boolean generatingIDs;
            names.clear();
            InternalRepository repository = this.getRepository();
            boolean bl = generatingIDs = repository.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE;
            if (generatingIDs) {
                names.add(PROP_NEXT_LOCAL_CDOID);
                names.add(PROP_LAST_CDOID);
            }
            names.add(PROP_LAST_BRANCHID);
            names.add(PROP_LAST_LOCAL_BRANCHID);
            names.add(PROP_LAST_COMMITTIME);
            names.add(PROP_LAST_NONLOCAL_COMMITTIME);
            map = this.getPersistentProperties(names);
            if (generatingIDs) {
                this.idHandler.setNextLocalObjectID(Store.stringToID((String)map.get(PROP_NEXT_LOCAL_CDOID)));
                this.idHandler.setLastObjectID(Store.stringToID((String)map.get(PROP_LAST_CDOID)));
            }
            this.setLastBranchID(Integer.valueOf(map.get(PROP_LAST_BRANCHID)));
            this.setLastLocalBranchID(Integer.valueOf(map.get(PROP_LAST_LOCAL_BRANCHID)));
            this.setLastCommitTime(Long.valueOf(map.get(PROP_LAST_COMMITTIME)));
            this.setLastNonLocalCommitTime(Long.valueOf(map.get(PROP_LAST_NONLOCAL_COMMITTIME)));
        } else {
            this.repairAfterCrash();
        }
        this.removePersistentProperties(Collections.singleton(PROP_GRACEFULLY_SHUT_DOWN));
    }

    protected void repairAfterCrash() {
        InternalRepository repository = this.getRepository();
        String name = repository.getName();
        OM.LOG.warn(MessageFormat.format(Messages.getString("DBStore.9"), name));
        Connection connection = this.getConnection();
        try {
            try {
                connection.setAutoCommit(false);
                connection.setReadOnly(true);
                this.mappingStrategy.repairAfterCrash(this.dbAdapter, connection);
                boolean storeIDs = repository.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE;
                CDOID lastObjectID = storeIDs ? this.idHandler.getLastObjectID() : CDOID.NULL;
                CDOID nextLocalObjectID = storeIDs ? this.idHandler.getNextLocalObjectID() : CDOID.NULL;
                int branchID = DBUtil.selectMaximumInt((Connection)connection, (IDBField)CDODBSchema.BRANCHES_ID, (String[])new String[0]);
                this.setLastBranchID(branchID > 0 ? branchID : 0);
                int localBranchID = DBUtil.selectMinimumInt((Connection)connection, (IDBField)CDODBSchema.BRANCHES_ID, (String[])new String[0]);
                this.setLastLocalBranchID(localBranchID < 0 ? localBranchID : 0);
                if (this.commitInfoTable != null) {
                    this.commitInfoTable.repairAfterCrash(connection);
                } else {
                    boolean branching = repository.isSupportingBranches();
                    long lastCommitTime = 0L;
                    long lastNonLocalCommitTime = 0L;
                    for (String tableName : DBUtil.getAllTableNames((Connection)connection, (String)repository.getName())) {
                        try {
                            IDBTable table;
                            IDBField createdField;
                            if (CDODBSchema.CDO_OBJECTS.equals(tableName) || (createdField = (table = this.database.getSchema().getTable(tableName)).getField("CDO_CREATED")) == null) continue;
                            if (branching) {
                                IDBField branchField = table.getField("CDO_BRANCH");
                                if (branchField == null) continue;
                                lastNonLocalCommitTime = Math.max(lastNonLocalCommitTime, DBUtil.selectMaximumLong((Connection)connection, (IDBField)branchField, (String[])new String[]{"0<=CDO_BRANCH"}));
                            }
                            lastCommitTime = Math.max(lastCommitTime, DBUtil.selectMaximumLong((Connection)connection, (IDBField)createdField, (String[])new String[0]));
                        }
                        catch (Exception ex) {
                            OM.LOG.warn(ex.getMessage());
                        }
                    }
                    if (lastNonLocalCommitTime == 0L) {
                        lastNonLocalCommitTime = lastCommitTime;
                    }
                    this.setLastCommitTime(lastCommitTime);
                    this.setLastNonLocalCommitTime(lastNonLocalCommitTime);
                }
                if (storeIDs) {
                    OM.LOG.info(MessageFormat.format(Messages.getString("DBStore.10"), name, lastObjectID, nextLocalObjectID, this.getLastBranchID(), this.getLastCommitTime(), this.getLastNonLocalCommitTime()));
                } else {
                    OM.LOG.info(MessageFormat.format(Messages.getString("DBStore.10b"), name, this.getLastBranchID(), this.getLastCommitTime(), this.getLastNonLocalCommitTime()));
                }
            }
            catch (SQLException e) {
                OM.LOG.error(MessageFormat.format(Messages.getString("DBStore.11"), name), (Throwable)e);
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    protected void configureAccessorPool(StoreAccessorPool pool, String property) {
        String value;
        if (pool != null && (value = this.properties.get(property)) != null) {
            int capacity = Integer.parseInt(value);
            pool.setCapacity(capacity);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int selectSchemaVersion(Connection connection) throws SQLException {
        ResultSet resultSet;
        Statement statement;
        block8: {
            int n;
            block7: {
                statement = null;
                resultSet = null;
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("SELECT " + CDODBSchema.PROPERTIES_VALUE + " FROM " + CDODBSchema.PROPERTIES + " WHERE " + CDODBSchema.PROPERTIES_NAME + "='" + PROP_SCHEMA_VERSION + "'");
                    if (resultSet.next()) {
                        String value = resultSet.getString(1);
                        n = Integer.parseInt(value);
                        DBUtil.close((ResultSet)resultSet);
                        break block7;
                    }
                    DBUtil.close((ResultSet)resultSet);
                    break block8;
                }
                catch (SQLException ex) {
                    connection.rollback();
                    if (!this.dbAdapter.isTableNotFoundException(ex)) throw ex;
                    return -1;
                }
            }
            DBUtil.close((Statement)statement);
            return n;
        }
        DBUtil.close((Statement)statement);
        return 0;
        finally {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)statement);
        }
    }

    protected void migrateSchema(int fromVersion) throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection();
            int version = fromVersion;
            while (version < 4) {
                if (SCHEMA_MIGRATORS[version] != null) {
                    int nextVersion = version + 1;
                    OM.LOG.info("Migrating schema from version " + version + " to version " + nextVersion + "...");
                    SCHEMA_MIGRATORS[version].migrateSchema(this, connection);
                }
                ++version;
            }
            connection.commit();
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    private static abstract class SchemaMigrator {
        private SchemaMigrator() {
        }

        public abstract void migrateSchema(DBStore var1, Connection var2) throws Exception;
    }
}

