/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewModuleInfoWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewModuleInfoWizardPage";
    private IJavaProject fProject;
    private static final String MODULE_INFO_JAVA_FILENAME = "module-info.java";
    private StringDialogField fModuleNameDialogField;
    private IStatus fModuleNameStatus;

    public NewModuleInfoWizardPage() {
        super(PAGE_NAME);
        String title = Messages.format(NewWizardMessages.NewModuleInfoWizardPage_title, MODULE_INFO_JAVA_FILENAME);
        this.setTitle(title);
        String description = Messages.format(NewWizardMessages.NewModuleInfoWizardPage_description, MODULE_INFO_JAVA_FILENAME);
        this.setDescription(description);
        ModuleFieldAdapter adapter = new ModuleFieldAdapter();
        this.fModuleNameDialogField = new StringDialogField();
        this.fModuleNameDialogField.setDialogFieldListener(adapter);
        this.fModuleNameDialogField.setLabelText(NewWizardMessages.NewModuleInfoWizardPage_module_label);
        this.fModuleNameStatus = new StatusInfo();
    }

    public void init(IJavaProject project) {
        if (project == null) {
            return;
        }
        this.fProject = project;
        IModuleDescription moduleDescription = null;
        try {
            moduleDescription = this.fProject.getModuleDescription();
        }
        catch (JavaModelException javaModelException) {}
        String moduleName = moduleDescription != null ? moduleDescription.getElementName() : this.fProject.getElementName();
        IStatus status = this.getModuleStatus(moduleName);
        if (status.getSeverity() == 0 || status.getSeverity() == 2 || status.getSeverity() == 1) {
            this.setModuleText(moduleName, true);
        } else {
            this.setModuleText("", true);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 2;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createModuleInfoControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    private void setFocus() {
        this.fModuleNameDialogField.setFocus();
    }

    private void createModuleInfoControls(Composite composite, int nColumns) {
        this.fModuleNameDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fModuleNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        DialogField.createEmptySpace(composite);
        TextFieldNavigationHandler.install(text);
        BidiUtils.applyBidiProcessing((Text)this.fModuleNameDialogField.getTextControl(null), (String)"java");
    }

    private int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(25);
    }

    private void handleFieldChanged() {
        this.updateStatus(this.fModuleNameStatus);
    }

    private IStatus validateModuleName(String name) {
        String sourceLevel = this.fProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = this.fProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validateModuleName((String)name, (String)sourceLevel, (String)complianceLevel);
    }

    private IStatus getModuleStatus(String moduleName) {
        StatusInfo status = new StatusInfo();
        if (moduleName != null && moduleName.length() > 0) {
            IStatus val = this.validateModuleName(moduleName);
            if (val.getSeverity() == 4) {
                status.setError(Messages.format(NewWizardMessages.NewModuleInfoWizardPage_error_InvalidModuleName, val.getMessage()));
            } else if (val.getSeverity() == 2) {
                status.setWarning(Messages.format(NewWizardMessages.NewModuleInfoWizardPage_warning_DiscouragedModuleName, val.getMessage()));
            }
        } else {
            status.setError(NewWizardMessages.NewModuleInfoWizardPage_error_EnterName);
        }
        return status;
    }

    public String getModuleNameText() {
        return this.fModuleNameDialogField.getText();
    }

    public IJavaProject getProject() {
        return this.fProject;
    }

    public IStatus getModuleNameStatus() {
        return this.fModuleNameStatus;
    }

    private void setModuleText(String moduleName, boolean canBeModified) {
        this.fModuleNameDialogField.setText(moduleName);
        this.fModuleNameDialogField.setEnabled(canBeModified);
    }

    private class ModuleFieldAdapter
    implements IDialogFieldListener {
        private ModuleFieldAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewModuleInfoWizardPage.this.fModuleNameStatus = NewModuleInfoWizardPage.this.getModuleStatus(NewModuleInfoWizardPage.this.getModuleNameText());
            NewModuleInfoWizardPage.this.handleFieldChanged();
        }
    }
}

