/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public abstract class JavaRenameProcessor
extends RenameProcessor
implements INameUpdating {
    private String fNewElementName;
    private RenameModifications fRenameModifications;

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fRenameModifications.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    public final RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        RefactoringStatus result = this.doCheckFinalConditions(pm, context);
        if (result.hasFatalError()) {
            return result;
        }
        IFile[] changed = this.getChangedFiles();
        int i = 0;
        while (i < changed.length) {
            deltaFactory.change(changed[i]);
            ++i;
        }
        this.fRenameModifications = this.computeRenameModifications();
        this.fRenameModifications.buildDelta(deltaFactory);
        this.fRenameModifications.buildValidateEdits((ValidateEditChecker)context.getChecker(ValidateEditChecker.class));
        return result;
    }

    protected abstract RenameModifications computeRenameModifications() throws CoreException;

    protected abstract RefactoringStatus doCheckFinalConditions(IProgressMonitor var1, CheckConditionsContext var2) throws CoreException, OperationCanceledException;

    protected abstract IFile[] getChangedFiles() throws CoreException;

    protected abstract String[] getAffectedProjectNatures() throws CoreException;

    @Override
    public void setNewElementName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewElementName = newName;
    }

    @Override
    public String getNewElementName() {
        return this.fNewElementName;
    }

    public abstract int getSaveMode();
}

