/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jsch.core.IJSchService;

class EclipseSshSessionFactory
extends JschConfigSessionFactory {
    private final IJSchService provider;

    EclipseSshSessionFactory(IJSchService p) {
        this.provider = p;
    }

    protected JSch createDefaultJSch(FS fs) throws JSchException {
        this.provider.createSession("127.0.0.1", 0, "eclipse");
        return this.provider.getJSch();
    }

    protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
        JSch jsch = this.getJSch(hc, FS.DETECTED);
        if (jsch == this.provider.getJSch()) {
            return this.provider.createSession(host, port, user);
        }
        return jsch.getSession(user, host, port);
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        UserInfo userInfo = session.getUserInfo();
        if (!hc.isBatchMode() && userInfo == null) {
            CredentialsProvider cp = CredentialsProvider.getDefault();
            session.setUserInfo((UserInfo)new CredentialsProviderUserInfo(session, cp));
        }
    }
}

