/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ExceptionUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public final class BlacklistedExceptions {
    private static final List<Class<? extends Throwable>> blacklist = Collections.singletonList(OutOfMemoryError.class);

    private BlacklistedExceptions() {
    }

    public static void rethrowIfBlacklisted(Throwable exception) {
        if (blacklist.stream().anyMatch(exceptionType -> exceptionType.isInstance(exception))) {
            ExceptionUtils.throwAsUncheckedException(exception);
        }
    }
}

