/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceUrlHandler;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.NewsViewer;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsUrlHandler
extends MarketplaceUrlHandler
implements LocationListener,
ProgressListener {
    private Set<String> documentLinks = null;
    private final NewsViewer viewer;

    public NewsUrlHandler(NewsViewer viewer) {
        this.viewer = viewer;
    }

    public void changed(LocationEvent event) {
        this.updatePageLinks();
    }

    private void updatePageLinks() {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Object[] links = null;
                try {
                    links = (Object[])NewsUrlHandler.this.viewer.getBrowser().evaluate("return (function() {   var links = document.links;   var hrefs = Array();   for (var i=0; i<links.length; i++) {      links[i].target='_self';      hrefs[i]=links[i].href;   };   return hrefs;})();");
                }
                catch (SWTException ex) {
                    MarketplaceClientUi.log(2, "Failed to process link targets on news page. Some links might not open in external browser.", ex);
                    NewsUrlHandler.this.documentLinks = null;
                }
                if (links != null) {
                    HashSet<String> documentLinks = new HashSet<String>();
                    Object[] objectArray = links;
                    int n = links.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object link = objectArray[n2];
                        documentLinks.add(link.toString());
                        ++n2;
                    }
                    NewsUrlHandler.this.documentLinks = documentLinks;
                }
            }
        });
    }

    public void changing(LocationEvent event) {
        if (!event.doit) {
            return;
        }
        String newLocation = event.location;
        boolean handled = this.handleUri(newLocation);
        if (handled) {
            event.doit = false;
        } else {
            String currentLocation = this.viewer.getBrowser().getUrl();
            if (this.isNavigation(currentLocation, newLocation)) {
                event.doit = false;
                this.viewer.getWizard().openUrl(newLocation);
            }
        }
    }

    private boolean isNavigation(String currentLocation, String newLocation) {
        if (NewsUrlHandler.eq(currentLocation, newLocation) || newLocation.startsWith("javascript:") || "about:blank".equals(newLocation) || "about:blank".equals(currentLocation)) {
            return false;
        }
        if (this.documentLinks == null || !this.documentLinks.contains(newLocation)) {
            return false;
        }
        return !NewsUrlHandler.isSameLocation(currentLocation, newLocation);
    }

    static boolean isSameLocation(String currentLocation, String newLocation) {
        try {
            URI currentUri = new URI(currentLocation);
            URI newUri = new URI(newLocation);
            return NewsUrlHandler.equalsHostAndPath(currentUri, newUri);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    static boolean equalsHostAndPath(URI currentLocation, URI newLocation) {
        return NewsUrlHandler.eq(currentLocation.getHost(), newLocation.getHost()) && NewsUrlHandler.equalsIgnoreTrailingSlash(currentLocation.getPath(), newLocation.getPath());
    }

    static boolean equalsIgnoreTrailingSlash(String path1, String path2) {
        if (path1.endsWith("/") && !path2.endsWith("/")) {
            path1 = path1.substring(0, path1.length() - 1);
        } else if (!path1.endsWith("/") && path2.endsWith("/")) {
            path2 = path2.substring(0, path2.length() - 1);
        }
        return NewsUrlHandler.eq(path1, path2);
    }

    static boolean eq(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    @Override
    protected boolean handleSearch(CatalogDescriptor descriptor, String url, String searchString, Map<String, String> params) {
        MarketplaceWizard marketplaceWizard = this.viewer.getWizard();
        String filterParam = params.get("filter");
        String[] filters = filterParam.split(" ");
        ICategory searchCategory = null;
        IMarket searchMarket = null;
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (filter.startsWith("tid:")) {
                String id = filter.substring("tid:".length());
                List catalogCategories = marketplaceWizard.getCatalog().getCategories();
                for (CatalogCategory catalogCategory : catalogCategories) {
                    if (!(catalogCategory instanceof MarketplaceCategory)) continue;
                    MarketplaceCategory marketplaceCategory = (MarketplaceCategory)catalogCategory;
                    List<? extends IMarket> markets = marketplaceCategory.getMarkets();
                    for (IMarket iMarket : markets) {
                        if (id.equals(iMarket.getId())) {
                            searchMarket = iMarket;
                            continue;
                        }
                        List categories = iMarket.getCategory();
                        for (ICategory category : categories) {
                            if (!id.equals(category.getId())) continue;
                            searchCategory = category;
                        }
                    }
                }
            }
            ++n2;
        }
        marketplaceWizard.getCatalogPage().search(descriptor, searchMarket, searchCategory, searchString);
        return true;
    }

    @Override
    protected boolean handleRecent(CatalogDescriptor descriptor, String url) {
        this.viewer.getWizard().getCatalogPage().show(descriptor, MarketplaceViewer.ContentType.RECENT);
        return true;
    }

    @Override
    protected boolean handlePopular(CatalogDescriptor descriptor, String url) {
        this.viewer.getWizard().getCatalogPage().show(descriptor, MarketplaceViewer.ContentType.POPULAR);
        return true;
    }

    @Override
    protected boolean handleNode(CatalogDescriptor descriptor, String url, INode node) {
        this.viewer.getWizard().getCatalogPage().show(descriptor, Collections.singleton(node));
        return true;
    }

    @Override
    protected boolean handleInstallRequest(MarketplaceUrlHandler.SolutionInstallationInfo installInfo, String url) {
        if (installInfo.getInstallId() == null) {
            return false;
        }
        MarketplaceWizard wizard = this.viewer.getWizard();
        return wizard.handleInstallRequest(installInfo, url);
    }

    public void completed(ProgressEvent event) {
        this.updatePageLinks();
    }

    public void changed(ProgressEvent event) {
    }
}

