/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.CartesianProduct;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.base.collect.GSetIntersection;
import org.eclipse.sirius.ext.base.collect.MultipleCollection;
import org.eclipse.sirius.ext.base.collect.SetIntersection;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.api.query.DTableQuery;
import org.eclipse.sirius.table.business.api.refresh.DTableSynchronizer;
import org.eclipse.sirius.table.business.internal.dialect.TableDialectServices;
import org.eclipse.sirius.table.business.internal.refresh.DCellCandidate;
import org.eclipse.sirius.table.business.internal.refresh.DFeatureColumnCandidate;
import org.eclipse.sirius.table.business.internal.refresh.DLineCandidate;
import org.eclipse.sirius.table.business.internal.refresh.DTableElementSynchronizer;
import org.eclipse.sirius.table.business.internal.refresh.DTargetColumnCandidate;
import org.eclipse.sirius.table.business.internal.refresh.KeyCache;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.EditionTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.FeatureColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.tools.internal.Messages;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;

public class DTableSynchronizerImpl
implements DTableSynchronizer {
    private final TableDescription description;
    private final IInterpreter interpreter;
    private final RuntimeLoggerInterpreter safeInterpreter;
    private final ModelAccessor accessor;
    private DTable table;
    private final DTableElementSynchronizer sync;
    private RefreshIdsHolder ids;

    public DTableSynchronizerImpl(TableDescription description, ModelAccessor accessor, IInterpreter interpreter) {
        this.accessor = accessor;
        this.description = description;
        this.interpreter = interpreter;
        this.safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
        this.sync = new DTableElementSynchronizer(accessor, interpreter);
    }

    @Override
    public void refresh(IProgressMonitor monitor) {
        try {
            if (this.description instanceof CrossTableDescription) {
                monitor.beginTask(Messages.DTableSynchronizerImpl_refreshCrossTabel, 3);
            } else {
                monitor.beginTask(Messages.DTableSynchronizerImpl_refreshEditionTabel, 2);
            }
            KeyCache.DEFAULT.clear();
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.REFRESH_TABLE_KEY);
            HashMap<TableMapping, Collection<DTableElement>> mappingToElements = new HashMap<TableMapping, Collection<DTableElement>>();
            ECrossReferenceAdapter xref = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)this.table.getTarget());
            this.refreshLines((IProgressMonitor)new SubProgressMonitor(monitor, 1), mappingToElements, xref);
            this.refreshColumns((IProgressMonitor)new SubProgressMonitor(monitor, 1), mappingToElements, xref);
            this.refreshCells((IProgressMonitor)new SubProgressMonitor(monitor, 1), mappingToElements, xref);
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.REFRESH_TABLE_KEY);
        }
        finally {
            monitor.done();
        }
    }

    private void refreshLines(IProgressMonitor monitor, Map<TableMapping, Collection<DTableElement>> mappingToElements, ECrossReferenceAdapter xref) {
        try {
            ArrayList lMappings = new ArrayList();
            if (this.description != null) {
                lMappings = this.description.getAllLineMappings();
            }
            monitor.beginTask(Messages.DTableSynchronizerImpl_refreshLineMapping, lMappings.size());
            int currentLineIndex = 0;
            for (LineMapping lMapping : lMappings) {
                currentLineIndex = this.refreshLineMapping(this.table, lMapping, mappingToElements, currentLineIndex, xref);
                monitor.worked(1);
            }
            if (lMappings.isEmpty()) {
                for (DLine lineToDelete : Lists.newArrayList((Iterable)this.table.getLines())) {
                    this.doDeleteLine(lineToDelete, xref);
                }
            }
            KeyCache.DEFAULT.clear();
        }
        finally {
            monitor.done();
        }
    }

    private void refreshColumns(IProgressMonitor monitor, Map<TableMapping, Collection<DTableElement>> mappingToElements, ECrossReferenceAdapter xref) {
        try {
            ArrayList cMappings = new ArrayList();
            if (this.description instanceof EditionTableDescription) {
                cMappings = ((EditionTableDescription)this.description).getAllColumnMappings();
            } else if (this.description instanceof CrossTableDescription) {
                cMappings = ((CrossTableDescription)this.description).getOwnedColumnMappings();
            }
            monitor.beginTask(Messages.DTableSynchronizerImpl_refreshColumnMapping, cMappings.size());
            int currentColumnIndex = 0;
            for (ColumnMapping cMapping : cMappings) {
                currentColumnIndex = this.refreshColumnMapping(cMapping, mappingToElements, currentColumnIndex, xref);
                monitor.worked(1);
            }
            if (cMappings.isEmpty()) {
                for (DColumn columnToDelete : Lists.newArrayList(this.table.getColumns())) {
                    this.doDeleteColumn(columnToDelete, xref);
                }
            }
            KeyCache.DEFAULT.clear();
        }
        finally {
            monitor.done();
        }
    }

    private void refreshCells(IProgressMonitor monitor, Map<TableMapping, Collection<DTableElement>> mappingToElements, ECrossReferenceAdapter xref) {
        if (this.description instanceof EditionTableDescription) {
            for (DColumn column : this.table.getColumns()) {
                for (DCell cell : Lists.newArrayList(column.getCells())) {
                    if (cell.getLine() != null) continue;
                    this.doDeleteCell(cell, xref);
                }
            }
            this.fillTableDCells(this.table);
        } else if (this.description instanceof CrossTableDescription) {
            this.refreshCellsOfCrossTable(monitor, mappingToElements, xref);
        }
        KeyCache.DEFAULT.clear();
    }

    private void refreshCellsOfCrossTable(IProgressMonitor monitor, Map<TableMapping, Collection<DTableElement>> mappingToElements, ECrossReferenceAdapter xref) {
        try {
            monitor.beginTask(Messages.DTableSynchronizerImpl_refreshIntersectionMapping, ((CrossTableDescription)this.description).getIntersection().size());
            if (((CrossTableDescription)this.description).getIntersection().isEmpty()) {
                for (DCell cell : new DTableQuery(this.table).getCells()) {
                    this.doDeleteCell(cell, xref);
                }
            } else {
                for (IntersectionMapping iMapping : ((CrossTableDescription)this.description).getIntersection()) {
                    this.refreshIntersectionMapping(iMapping, mappingToElements, xref);
                    monitor.worked(1);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void fillTableDCells(LineContainer lContainer) {
        for (DLine line : lContainer.getLines()) {
            this.fillTableDCell(line);
        }
    }

    private void fillTableDCell(DLine line) {
        DCell cell;
        GSetIntersection status = new GSetIntersection();
        for (DCell cell2 : line.getCells()) {
            status.addInOld((Object)new DCellCandidate(cell2, this.ids));
        }
        for (DColumn column : this.table.getColumns()) {
            ColumnMapping mapping = column.getOriginMapping();
            Option<DCell> optionalCell = TableHelper.getCell(line, column);
            EObject target = optionalCell.some() ? ((DCell)optionalCell.get()).getTarget() : line.getTarget();
            status.addInNew((Object)new DCellCandidate(mapping, target, line, column, this.ids));
        }
        for (DCellCandidate toCreate : status.getNewElements()) {
            Option<DCell> optionalCell = this.createCell(toCreate.getLine(), toCreate.getColumn(), toCreate.getSemantic(), toCreate.getMapping());
            if (!optionalCell.some() || !this.refresh((DCell)optionalCell.get())) continue;
            this.sync.refreshSemanticElements((DCell)optionalCell.get());
        }
        for (DCellCandidate toUpdate : status.getKeptElements()) {
            cell = toUpdate.getOriginalElement();
            if (cell == null || !this.refresh(cell)) continue;
            this.sync.refreshSemanticElements(cell);
        }
        for (DCellCandidate toRemove : status.getRemovedElements()) {
            cell = toRemove.getOriginalElement();
            if (cell == null) continue;
            DLine parentLine = cell.getLine();
            DColumn parentColumn = cell.getColumn();
            if (!this.accessor.getPermissionAuthority().canEditInstance((EObject)parentColumn) || !this.accessor.getPermissionAuthority().canEditInstance((EObject)parentLine)) continue;
            parentLine.getCells().remove((Object)cell);
            if (parentColumn == null) continue;
            parentColumn.getCells().remove((Object)cell);
        }
        this.fillTableDCells(line);
    }

    private boolean refresh(DCell cell) {
        boolean cellStillExists = true;
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)cell)) {
            if (this.sync.refreshTarget(cell)) {
                if (this.sync.refreshLabel(cell)) {
                    this.sync.refreshStyle(cell);
                } else {
                    cellStillExists = false;
                }
            } else {
                cellStillExists = false;
            }
        }
        return cellStillExists;
    }

    private Option<DCell> createCell(DLine line, DColumn column, EObject semantic, ColumnMapping mapping) {
        Option result;
        DCell newCell = TableFactory.eINSTANCE.createDCell();
        newCell.setTarget(semantic);
        if (mapping instanceof FeatureColumnMapping) {
            FeatureColumnMapping cMapping = (FeatureColumnMapping)mapping;
            EObject featureParent = line.getTarget();
            String featureParentExpression = cMapping.getFeatureParentExpression();
            if (featureParentExpression != null && featureParentExpression.length() > 0) {
                if (line != null) {
                    this.interpreter.setVariable("container", (Object)line.getTarget());
                    this.interpreter.setVariable("line", (Object)line);
                }
                if (this.table != null) {
                    this.interpreter.setVariable("root", (Object)this.table.getTarget());
                    this.interpreter.setVariable("table", (Object)this.table);
                }
                featureParent = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateEObject(line.getTarget(), (EObject)cMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getFeatureColumnMapping_FeatureParentExpression());
                if (line != null) {
                    this.interpreter.unSetVariable("container");
                    this.interpreter.unSetVariable("line");
                }
                if (this.table != null) {
                    this.interpreter.unSetVariable("root");
                    this.interpreter.unSetVariable("table");
                }
            }
            newCell.setTarget(featureParent);
            String featureName = cMapping.getFeatureName();
            if (newCell.getTarget() == null || !"*".equals(featureName) && !this.accessor.eValid(newCell.getTarget(), featureName)) {
                newCell = null;
            }
        }
        if (newCell == null) {
            result = Options.newNone();
        } else {
            newCell.setLine(line);
            newCell.setColumn(column);
            result = Options.newSome((Object)newCell);
        }
        return result;
    }

    private int refreshColumnMapping(ColumnMapping mapping, Map<TableMapping, Collection<DTableElement>> mappingToElements, int previousCurrentIndex, ECrossReferenceAdapter xref) {
        int result = 0;
        if (mapping instanceof FeatureColumnMapping) {
            result = this.refreshFeatureColumnMapping((FeatureColumnMapping)mapping, mappingToElements, previousCurrentIndex, xref);
        } else if (mapping instanceof ElementColumnMapping) {
            result = this.refreshElementColumnMapping((ElementColumnMapping)mapping, mappingToElements, previousCurrentIndex, xref);
        }
        return result;
    }

    private int refreshElementColumnMapping(ElementColumnMapping mapping, Map<TableMapping, Collection<DTableElement>> mappingToElements, int previousCurrentIndex, ECrossReferenceAdapter xref) {
        int currentIndex = previousCurrentIndex;
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)this.table)) {
            SetIntersection<DTargetColumnCandidate> status = this.computeCurrentStatus(mapping, xref);
            ArrayList<DTableElement> elementsToKeep = new ArrayList<DTableElement>();
            for (DTargetColumnCandidate toDelete : status.getRemovedElements()) {
                if (toDelete.getOriginalElement() == null) continue;
                this.doDeleteColumn(toDelete.getOriginalElement(), xref);
            }
            for (DTargetColumnCandidate targetColumnCandidate : status.getAllElements()) {
                if (targetColumnCandidate.getOriginalElement() == null) {
                    DTargetColumn newC = this.createNewColumn(targetColumnCandidate.getMapping(), targetColumnCandidate.getSemantic());
                    this.sync.refresh((DColumn)newC);
                    this.sync.refreshSemanticElements(newC, targetColumnCandidate.getMapping());
                    if (this.accessor.getPermissionAuthority().canCreateIn((EObject)this.table)) {
                        this.table.getColumns().add(currentIndex, (Object)newC);
                    }
                    elementsToKeep.add(newC);
                } else {
                    this.sync.refresh((DColumn)targetColumnCandidate.getOriginalElement());
                    this.sync.refreshSemanticElements(targetColumnCandidate.getOriginalElement(), targetColumnCandidate.getMapping());
                    DTable parentTable = targetColumnCandidate.getOriginalElement().getTable();
                    if (parentTable.getColumns().size() >= currentIndex) {
                        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)parentTable) && !targetColumnCandidate.getOriginalElement().equals(parentTable.getColumns().get(currentIndex))) {
                            parentTable.getColumns().move(currentIndex, (Object)targetColumnCandidate.getOriginalElement());
                        }
                    } else if (this.accessor.getPermissionAuthority().canEditInstance((EObject)parentTable)) {
                        parentTable.getColumns().move(parentTable.getColumns().size() - 1, (Object)targetColumnCandidate.getOriginalElement());
                    }
                    elementsToKeep.add(targetColumnCandidate.getOriginalElement());
                }
                ++currentIndex;
            }
            this.putOrAdd(mappingToElements, mapping, elementsToKeep);
        }
        return currentIndex;
    }

    private SetIntersection<DTargetColumnCandidate> computeCurrentStatus(ElementColumnMapping mapping, ECrossReferenceAdapter xref) {
        GSetIntersection status = new GSetIntersection();
        ArrayList<DColumn> columnsWithoutTarget = new ArrayList<DColumn>();
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)this.table)) {
            for (DColumn column : this.table.getColumns()) {
                boolean mappingIsObsolete;
                boolean bl = TableDialectServices.isHandledByMovida(this.table) ? false : (mappingIsObsolete = column.getOriginMapping().eResource() == null || column.getOriginMapping().eIsProxy());
                if (!mappingIsObsolete && (column.getOriginMapping() != mapping || !(column instanceof DFeatureColumn))) continue;
                columnsWithoutTarget.add(column);
            }
            for (DColumn column : this.table.getColumns()) {
                if (column.getTarget() != null) continue;
                columnsWithoutTarget.add(column);
            }
            for (DColumn columnWithoutTarget : columnsWithoutTarget) {
                this.doDeleteColumn(columnWithoutTarget, xref);
            }
        }
        for (DColumn column : this.table.getColumns()) {
            if (column.getOriginMapping() != mapping || !(column instanceof DTargetColumn)) continue;
            status.addInOld((Object)new DTargetColumnCandidate((DTargetColumn)column, this.ids));
        }
        MultipleCollection semantics = new MultipleCollection();
        if (TableHelper.hasSemanticCandidatesExpression(mapping)) {
            this.interpreter.setVariable("containerView", (Object)this.table);
            this.interpreter.setVariable("container", (Object)this.table.getTarget());
            this.interpreter.setVariable("viewpoint", (Object)this.table);
            this.interpreter.setVariable("table", (Object)this.table);
            Collection candidates = this.safeInterpreter.evaluateCollection(this.table.getTarget(), (EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getElementColumnMapping_SemanticCandidatesExpression());
            if (!candidates.isEmpty()) {
                semantics.addAll(candidates);
            }
            this.interpreter.unSetVariable("table");
            this.interpreter.unSetVariable("viewpoint");
            this.interpreter.unSetVariable("container");
            this.interpreter.unSetVariable("containerView");
        } else {
            semantics.addAll(this.accessor.eAllContents(this.table.getTarget(), mapping.getDomainClass()));
        }
        for (EObject semantic : semantics) {
            if (!this.accessor.eInstanceOf(semantic, mapping.getDomainClass())) continue;
            status.addInNew((Object)new DTargetColumnCandidate(mapping, semantic, this.ids));
        }
        return status;
    }

    private int refreshFeatureColumnMapping(FeatureColumnMapping mapping, Map<TableMapping, Collection<DTableElement>> mappingToElements, int previousCurrentIndex, ECrossReferenceAdapter xref) {
        int currentIndex = previousCurrentIndex;
        if (this.accessor.getPermissionAuthority().canCreateIn((EObject)this.table)) {
            SetIntersection<DFeatureColumnCandidate> status = this.computeCurrentStatus(mapping);
            for (DFeatureColumnCandidate toDelete : status.getRemovedElements()) {
                if (toDelete.getOriginalElement() == null) continue;
                this.doDeleteColumn(toDelete.getOriginalElement(), xref);
            }
            for (DFeatureColumnCandidate featureColumnCandidate : status.getAllElements()) {
                if (featureColumnCandidate.getOriginalElement() == null) {
                    DFeatureColumn newC = this.createNewColumn(featureColumnCandidate.getMapping(), featureColumnCandidate.getFeatureName());
                    this.sync.refresh(newC);
                    this.table.getColumns().add(currentIndex, (Object)newC);
                } else {
                    this.sync.refresh(featureColumnCandidate.getOriginalElement());
                    DTable parentTable = featureColumnCandidate.getOriginalElement().getTable();
                    if (parentTable.getColumns().size() >= currentIndex) {
                        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)parentTable) && !featureColumnCandidate.getOriginalElement().equals(parentTable.getColumns().get(currentIndex))) {
                            parentTable.getColumns().move(currentIndex, (Object)featureColumnCandidate.getOriginalElement());
                        }
                    } else if (this.accessor.getPermissionAuthority().canEditInstance((EObject)parentTable)) {
                        parentTable.getColumns().move(parentTable.getColumns().size() - 1, (Object)featureColumnCandidate.getOriginalElement());
                    }
                }
                ++currentIndex;
            }
        }
        return currentIndex;
    }

    private SetIntersection<DFeatureColumnCandidate> computeCurrentStatus(FeatureColumnMapping mapping) {
        GSetIntersection status = new GSetIntersection();
        for (DColumn column : this.table.getColumns()) {
            boolean mappingIsObsolete;
            boolean bl = TableDialectServices.isHandledByMovida(this.table) ? false : (mappingIsObsolete = column.getOriginMapping().eResource() == null || column.getOriginMapping().eIsProxy());
            if (!mappingIsObsolete && (column.getOriginMapping() != mapping || !(column instanceof DFeatureColumn))) continue;
            status.addInOld((Object)new DFeatureColumnCandidate((DFeatureColumn)column, this.ids));
        }
        status.addInNew((Object)new DFeatureColumnCandidate(mapping, mapping.getFeatureName(), this.ids));
        return status;
    }

    private int refreshLineMapping(LineContainer container, LineMapping mapping, Map<TableMapping, Collection<DTableElement>> mappingToElements, int previousCurrentIndex, ECrossReferenceAdapter xref) {
        int currentIndex = previousCurrentIndex;
        SetIntersection<DLineCandidate> status = this.computeCurrentStatus(container, mapping, xref);
        ArrayList<DLine> possibleContainers = new ArrayList<DLine>();
        ArrayList<DTableElement> elementsToKeep = new ArrayList<DTableElement>();
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)container)) {
            for (DLineCandidate toDelete : status.getRemovedElements()) {
                if (toDelete.getOriginalElement() == null) continue;
                this.doDeleteLine(toDelete.getOriginalElement(), xref);
            }
        }
        for (DLineCandidate lineCandidate : status.getAllElements()) {
            if (lineCandidate.getOriginalElement() == null) {
                if (this.accessor.getPermissionAuthority().canEditInstance((EObject)container)) {
                    DLine newL = this.createNewLine(lineCandidate.getMapping(), lineCandidate.getSemantic());
                    container.getLines().add(currentIndex, (Object)newL);
                    this.sync.refresh(newL);
                    this.sync.refreshSemanticElements(newL, lineCandidate.getMapping());
                    possibleContainers.add(newL);
                    elementsToKeep.add(newL);
                }
            } else {
                if (this.accessor.getPermissionAuthority().canEditInstance((EObject)lineCandidate.getOriginalElement())) {
                    this.sync.refresh(lineCandidate.getOriginalElement());
                    this.sync.refreshSemanticElements(lineCandidate.getOriginalElement(), lineCandidate.getMapping());
                    LineContainer lineContainer = (LineContainer)lineCandidate.getOriginalElement().eContainer();
                    if (lineContainer.getLines().size() >= currentIndex) {
                        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)lineContainer) && !lineCandidate.getOriginalElement().equals(lineContainer.getLines().get(currentIndex))) {
                            lineContainer.getLines().move(currentIndex, (Object)lineCandidate.getOriginalElement());
                        }
                    } else if (this.accessor.getPermissionAuthority().canEditInstance((EObject)lineContainer)) {
                        lineContainer.getLines().move(lineContainer.getLines().size() - 1, (Object)lineCandidate.getOriginalElement());
                    }
                    possibleContainers.add(lineCandidate.getOriginalElement());
                }
                elementsToKeep.add(lineCandidate.getOriginalElement());
            }
            ++currentIndex;
        }
        this.putOrAdd(mappingToElements, mapping, elementsToKeep);
        for (DLine newContainer : possibleContainers) {
            int currentSubIndex = 0;
            EList<LineMapping> allSubLines = newContainer.getOriginMapping().getAllSubLines();
            for (LineMapping subMapping : allSubLines) {
                currentSubIndex = this.refreshLineMapping(newContainer, subMapping, mappingToElements, currentSubIndex, xref);
            }
            if (!allSubLines.isEmpty() || newContainer.getLines().isEmpty() || !this.accessor.getPermissionAuthority().canEditInstance((EObject)newContainer)) continue;
            for (DLine lineToDelete : Lists.newArrayList(newContainer.getLines())) {
                this.doDeleteLine(lineToDelete, xref);
            }
        }
        return currentIndex;
    }

    private void refreshIntersectionMapping(IntersectionMapping iMapping, Map<TableMapping, Collection<DTableElement>> mappingToElements, ECrossReferenceAdapter xref) {
        if (iMapping.isUseDomainClass()) {
            this.refreshIntersectionMappingWithDomain(iMapping, mappingToElements, xref);
        } else {
            this.refreshIntersectionMappingWithoutDomain(iMapping, mappingToElements, xref);
        }
    }

    private void refreshIntersectionMappingWithDomain(IntersectionMapping iMapping, Map<TableMapping, Collection<DTableElement>> mappingToElements, ECrossReferenceAdapter xref) {
        GSetIntersection status = new GSetIntersection();
        for (DCell cell : new DTableQuery(this.table).getCells()) {
            boolean mappingIsObsolete;
            IntersectionMapping intersectionMapping = cell.getIntersectionMapping();
            boolean bl = TableDialectServices.isHandledByMovida(this.table) ? false : (mappingIsObsolete = intersectionMapping == null || intersectionMapping.eResource() == null);
            if (!iMapping.equals(intersectionMapping) && !mappingIsObsolete) continue;
            status.addInOld((Object)new DCellCandidate(cell, this.ids));
        }
        EObject rootContent = this.table.getTarget();
        Collection targetCandidates = StringUtil.isEmpty((String)iMapping.getSemanticCandidatesExpression()) ? this.accessor.eAllContents(rootContent, iMapping.getDomainClass()) : this.safeInterpreter.evaluateCollection(rootContent, (EObject)iMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getIntersectionMapping_SemanticCandidatesExpression());
        Collection<DTableElement> columnViews = mappingToElements.get(iMapping.getColumnMapping());
        MultipleCollection lineViews = new MultipleCollection();
        for (LineMapping lMapping : iMapping.getLineMapping()) {
            Collection<DTableElement> lines = mappingToElements.get(lMapping);
            if (lines == null) continue;
            lineViews.addAll(lines);
        }
        if (targetCandidates.size() > 0 && columnViews != null && lineViews != null) {
            HashMap<EObject, Collection<DLine>> linesSemantics = new HashMap<EObject, Collection<DLine>>(lineViews.size());
            for (DTableElement tableElement : lineViews) {
                if (!(tableElement instanceof DLine)) continue;
                this.putOrAdd(linesSemantics, ((DLine)tableElement).getTarget(), (DLine)tableElement);
            }
            HashMap<EObject, Collection<DColumn>> columnSemantics = new HashMap<EObject, Collection<DColumn>>(columnViews.size());
            for (DTableElement tableElement : columnViews) {
                if (!(tableElement instanceof DTargetColumn)) continue;
                this.putOrAdd(columnSemantics, ((DTargetColumn)tableElement).getTarget(), (DColumn)tableElement);
            }
            for (EObject target : targetCandidates) {
                Collection lineSemanticCandidates = this.safeInterpreter.evaluateCollection(target, (EObject)iMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getIntersectionMapping_LineFinderExpression());
                Collection columnSemanticCandidates = this.safeInterpreter.evaluateCollection(target, (EObject)iMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getIntersectionMapping_ColumnFinderExpression());
                for (EObject lineSemantic : lineSemanticCandidates) {
                    for (EObject columnSemantic : columnSemanticCandidates) {
                        Collection targetViews;
                        Collection sourceViews = (Collection)linesSemantics.get(lineSemantic);
                        if (sourceViews == null || (targetViews = (Collection)columnSemantics.get(columnSemantic)) == null) continue;
                        for (EObjectCouple viewsCouple : new CartesianProduct(sourceViews, targetViews, this.ids)) {
                            DLine line = (DLine)viewsCouple.getObj1();
                            DColumn column = (DColumn)viewsCouple.getObj2();
                            if (!this.checkIntersectionPrecondition(column.getTarget(), line, column, iMapping.getPreconditionExpression())) continue;
                            status.addInNew((Object)new DCellCandidate(iMapping.getColumnMapping(), target, line, column, this.ids));
                        }
                    }
                }
            }
        }
        this.updateCells(iMapping, (SetIntersection<DCellCandidate>)status, xref);
    }

    private void updateCells(IntersectionMapping iMapping, SetIntersection<DCellCandidate> cellsToUpdate, ECrossReferenceAdapter xref) {
        DCell cell;
        for (DCellCandidate toCreate : cellsToUpdate.getNewElements()) {
            Option<DCell> optionalCell = this.createCell(toCreate.getLine(), toCreate.getColumn(), toCreate.getSemantic(), toCreate.getMapping());
            if (!optionalCell.some()) continue;
            ((DCell)optionalCell.get()).setIntersectionMapping(iMapping);
            this.sync.refresh((DCell)optionalCell.get());
        }
        for (DCellCandidate toUpdate : cellsToUpdate.getKeptElements()) {
            cell = toUpdate.getOriginalElement();
            if (cell == null || !this.accessor.getPermissionAuthority().canEditInstance((EObject)cell)) continue;
            if (cell.getTarget() != toUpdate.getSemantic()) {
                cell.setTarget(toUpdate.getSemantic());
            }
            cell.getSemanticElements().add((Object)toUpdate.getSemantic());
            if (cell.getIntersectionMapping() != iMapping) {
                cell.setIntersectionMapping(iMapping);
            }
            this.sync.refresh(cell);
        }
        for (DCellCandidate toRemove : cellsToUpdate.getRemovedElements()) {
            cell = toRemove.getOriginalElement();
            this.doDeleteCell(cell, xref);
        }
    }

    private void putOrAdd(Map<EObject, Collection<DLine>> map, EObject target, DLine tableElement) {
        Collection<DLine> existing = map.get(target);
        if (existing == null) {
            existing = new ArrayList<DLine>();
            existing.add(tableElement);
            map.put(target, existing);
        } else {
            existing.add(tableElement);
        }
    }

    private void putOrAdd(Map<EObject, Collection<DColumn>> map, EObject target, DColumn tableElement) {
        Collection<DColumn> existing = map.get(target);
        if (existing == null) {
            existing = new ArrayList<DColumn>();
            existing.add(tableElement);
            map.put(target, existing);
        } else {
            existing.add(tableElement);
        }
    }

    private void refreshIntersectionMappingWithoutDomain(IntersectionMapping iMapping, Map<TableMapping, Collection<DTableElement>> mappingToElements, ECrossReferenceAdapter xref) {
        SetIntersection status = new SetIntersection();
        for (DCell cell : new DTableQuery(this.table).getCells()) {
            boolean mappingIsObsolete;
            IntersectionMapping intersectionMapping = cell.getIntersectionMapping();
            boolean bl = TableDialectServices.isHandledByMovida(this.table) ? false : (mappingIsObsolete = intersectionMapping == null || intersectionMapping.eResource() == null);
            if (!iMapping.equals(intersectionMapping) && !mappingIsObsolete) continue;
            status.addInOld((Object)new DCellCandidate(cell, this.ids));
        }
        for (LineMapping curLineMapping : iMapping.getLineMapping()) {
            Collection<DTableElement> sourceLines = mappingToElements.get(curLineMapping);
            Collection<DTableElement> targetColumns = mappingToElements.get(iMapping.getColumnMapping());
            HashMap linesToColumnSemantics = new HashMap();
            if (sourceLines == null || targetColumns == null) continue;
            for (DTableElement lineElem : sourceLines) {
                for (DTableElement columnElem : targetColumns) {
                    if (!(lineElem instanceof DLine) || !(columnElem instanceof DTargetColumn)) continue;
                    DLine line = (DLine)lineElem;
                    DTargetColumn column = (DTargetColumn)columnElem;
                    Collection columnSemantics = (ArrayList)linesToColumnSemantics.get(line);
                    if (columnSemantics == null) {
                        try {
                            columnSemantics = this.interpreter.evaluateCollection(line.getTarget(), iMapping.getColumnFinderExpression());
                        }
                        catch (EvaluationException e) {
                            columnSemantics = new ArrayList(0);
                            RuntimeLoggerManager.INSTANCE.error((EObject)line, (EStructuralFeature)DescriptionPackage.eINSTANCE.getIntersectionMapping_ColumnFinderExpression(), (Throwable)e);
                        }
                        linesToColumnSemantics.put(line, columnSemantics);
                    }
                    if (!columnSemantics.contains(column.getTarget()) || !this.checkIntersectionPrecondition(column.getTarget(), line, column, iMapping.getPreconditionExpression())) continue;
                    status.addInNew((Object)new DCellCandidate(iMapping.getColumnMapping(), line.getTarget(), line, column, this.ids));
                }
            }
        }
        this.updateCells(iMapping, (SetIntersection<DCellCandidate>)status, xref);
    }

    private void putOrAdd(Map<TableMapping, Collection<DTableElement>> map, TableMapping mapping, Collection<DTableElement> elements) {
        MultipleCollection existing = map.get(mapping);
        if (existing == null) {
            existing = new MultipleCollection();
            existing.addAll(elements);
            map.put(mapping, (Collection<DTableElement>)existing);
        } else {
            existing.addAll(elements);
        }
    }

    private DLine createNewLine(LineMapping mapping, EObject semantic) {
        DLine line = TableFactory.eINSTANCE.createDLine();
        line.setOriginMapping(mapping);
        line.setTarget(semantic);
        return line;
    }

    private DFeatureColumn createNewColumn(ColumnMapping mapping, String featureName) {
        DFeatureColumn column = TableFactory.eINSTANCE.createDFeatureColumn();
        column.setOriginMapping(mapping);
        column.setFeatureName(featureName);
        return column;
    }

    private DTargetColumn createNewColumn(ColumnMapping mapping, EObject semantic) {
        DTargetColumn column = TableFactory.eINSTANCE.createDTargetColumn();
        column.setOriginMapping(mapping);
        column.setTarget(semantic);
        return column;
    }

    private void doDeleteLine(DLine lineToDelete, ECrossReferenceAdapter xref) {
        for (DLine line : Sets.newLinkedHashSet(lineToDelete.getLines())) {
            this.doDeleteLine(line, xref);
        }
        for (DCell cell : Sets.newLinkedHashSet(lineToDelete.getCells())) {
            this.doDeleteCell(cell, xref);
        }
        if (this.accessor.getPermissionAuthority().canDeleteInstance((EObject)lineToDelete)) {
            this.accessor.eDelete((EObject)lineToDelete, xref);
        }
    }

    private void doDeleteColumn(DColumn columnToDelete, ECrossReferenceAdapter xref) {
        for (DCell cell : Sets.newLinkedHashSet(columnToDelete.getCells())) {
            this.doDeleteCell(cell, xref);
        }
        if (this.accessor.getPermissionAuthority().canDeleteInstance((EObject)columnToDelete)) {
            this.accessor.eDelete((EObject)columnToDelete, xref);
        }
    }

    private void doDeleteCell(DCell cell, ECrossReferenceAdapter xref) {
        this.sync.removeUneededCell(cell);
    }

    private SetIntersection<DLineCandidate> computeCurrentStatus(LineContainer container, LineMapping mapping, ECrossReferenceAdapter xref) {
        SetIntersection status = new SetIntersection();
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)container)) {
            ArrayList<DLine> linesWithoutTarget = new ArrayList<DLine>();
            for (DLine line : container.getLines()) {
                if (line.getTarget() != null) continue;
                linesWithoutTarget.add(line);
            }
            for (Object lineWithoutTarget : linesWithoutTarget) {
                this.doDeleteLine((DLine)lineWithoutTarget, xref);
            }
        }
        for (DLine line : container.getLines()) {
            boolean mappingIsObsolete;
            LineMapping originMapping = line.getOriginMapping();
            boolean bl = TableDialectServices.isHandledByMovida(this.table) ? false : (mappingIsObsolete = originMapping.eResource() == null);
            if (originMapping != mapping && !mappingIsObsolete) continue;
            status.addInOld((Object)new DLineCandidate(line, this.ids));
        }
        MultipleCollection semantics = new MultipleCollection();
        if (TableHelper.hasSemanticCandidatesExpression(mapping)) {
            this.interpreter.setVariable("containerView", (Object)container);
            this.interpreter.setVariable("container", (Object)container.getTarget());
            this.interpreter.setVariable("root", (Object)this.table.getTarget());
            this.interpreter.setVariable("viewpoint", (Object)this.table);
            this.interpreter.setVariable("table", (Object)this.table);
            Collection candidates = this.safeInterpreter.evaluateCollection(container.getTarget(), (EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getLineMapping_SemanticCandidatesExpression());
            semantics.addAll(candidates);
            this.interpreter.unSetVariable("table");
            this.interpreter.unSetVariable("viewpoint");
            this.interpreter.unSetVariable("root");
            this.interpreter.unSetVariable("container");
            this.interpreter.unSetVariable("containerView");
        } else {
            semantics.addAll(this.accessor.eAllContents(container.getTarget(), mapping.getDomainClass()));
        }
        for (EObject semantic : semantics) {
            if (!this.accessor.eInstanceOf(semantic, mapping.getDomainClass())) continue;
            status.addInNew((Object)new DLineCandidate(mapping, semantic, container, this.ids));
        }
        return status;
    }

    @Override
    public void setTable(DTable newTable) {
        this.table = newTable;
        this.ids = RefreshIdsHolder.getOrCreateHolder((EObject)this.table);
    }

    @Override
    public DTable getTable() {
        return this.table;
    }

    private boolean checkIntersectionPrecondition(EObject semanticColumn, DLine line, DColumn column, String preconditionExpression) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.CHECK_PRECONDITION_KEY);
        boolean result = true;
        if (!StringUtil.isEmpty((String)preconditionExpression)) {
            this.interpreter.setVariable("line", (Object)line);
            this.interpreter.setVariable("lineSemantic", (Object)line.getTarget());
            this.interpreter.setVariable("column", (Object)column);
            this.interpreter.setVariable("columnSemantic", (Object)column.getTarget());
            this.interpreter.setVariable("table", (Object)this.table);
            try {
                result = this.interpreter.evaluateBoolean(semanticColumn, preconditionExpression);
            }
            catch (EvaluationException evaluationException) {}
            this.interpreter.unSetVariable("line");
            this.interpreter.unSetVariable("lineSemantic");
            this.interpreter.unSetVariable("column");
            this.interpreter.unSetVariable("columnSemantic");
            this.interpreter.unSetVariable("table");
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.CHECK_PRECONDITION_KEY);
        return result;
    }
}

