/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.http.internal.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.http.common.IHTTPConnector;
import org.eclipse.net4j.http.internal.common.HTTPConnector;
import org.eclipse.net4j.http.internal.server.HTTPServerConnector;
import org.eclipse.net4j.http.internal.server.bundle.OM;
import org.eclipse.net4j.http.internal.server.messages.Messages;
import org.eclipse.net4j.http.server.IHTTPAcceptor;
import org.eclipse.net4j.http.server.INet4jTransportServlet;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.IRandomizer;
import org.eclipse.spi.net4j.Acceptor;
import org.eclipse.spi.net4j.InternalConnector;

public class HTTPAcceptor
extends Acceptor
implements IHTTPAcceptor,
INet4jTransportServlet.RequestHandler {
    public static final int DEFAULT_CONNECTOR_ID_LENGTH = 32;
    public static final int DEFAULT_MAX_IDLE_TIME = 1800000;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HTTPAcceptor.class);
    private IRandomizer randomizer;
    private INet4jTransportServlet servlet;
    private int connectorIDLength = 32;
    private int maxIdleTime = 1800000;
    private Map<String, HTTPServerConnector> httpConnectors = new HashMap<String, HTTPServerConnector>();
    private Worker cleaner = new Worker(){

        protected void work(Worker.WorkContext context) throws Exception {
            int pause = HTTPAcceptor.this.cleanIdleConnectors();
            context.nextWork((long)pause);
        }

        protected String getThreadName() {
            return "HTTPAcceptorCleaner";
        }
    };

    public IRandomizer getRandomizer() {
        return this.randomizer;
    }

    public void setRandomizer(IRandomizer randomizer) {
        this.randomizer = randomizer;
    }

    public INet4jTransportServlet getServlet() {
        return this.servlet;
    }

    public void setServlet(INet4jTransportServlet servlet) {
        if (this.servlet != null) {
            this.servlet.setRequestHandler(null);
        }
        this.servlet = servlet;
        if (this.servlet != null) {
            this.servlet.setRequestHandler(this);
        }
    }

    public int getConnectorIDLength() {
        return this.connectorIDLength;
    }

    public void setConnectorIDLength(int connectorIDLength) {
        this.connectorIDLength = connectorIDLength;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public IHTTPConnector[] getHTTPConnectors() {
        ArrayList<IHTTPConnector> result = new ArrayList<IHTTPConnector>();
        IConnector[] iConnectorArray = this.getAcceptedConnectors();
        int n = iConnectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnector acceptedConnector = iConnectorArray[n2];
            IHTTPConnector connector = (IHTTPConnector)acceptedConnector;
            result.add(connector);
            ++n2;
        }
        return result.toArray(new IHTTPConnector[result.size()]);
    }

    public IHTTPConnector[] handleList(String connectorID) {
        if (StringUtil.isEmpty((String)connectorID)) {
            return this.getHTTPConnectors();
        }
        return new IHTTPConnector[]{(IHTTPConnector)this.httpConnectors.get(connectorID)};
    }

    public IHTTPConnector handleConnect(String userID) {
        String connectorID = this.createConnectorID(userID);
        HTTPServerConnector connector = this.createServerConnector();
        this.prepareConnector((InternalConnector)connector);
        connector.setConnectorID(connectorID);
        connector.setUserID(userID);
        this.addConnector((InternalConnector)connector);
        connector.activate();
        return connector;
    }

    public void handleDisonnect(String connectorID) {
        HTTPConnector connector = this.httpConnectors.get(connectorID);
        if (connector == null) {
            throw new IllegalArgumentException("Invalid connectorID: " + connectorID);
        }
        connector.deactivate();
    }

    public void handleOperations(String connectorID, ExtendedDataInputStream in, ExtendedDataOutputStream out) throws IOException {
        HTTPServerConnector connector = this.httpConnectors.get(connectorID);
        if (connector == null) {
            throw new IllegalArgumentException("Invalid connectorID: " + connectorID);
        }
        connector.readInputOperations(in);
        connector.writeOutputOperations(out);
    }

    public String toString() {
        return "HTTPAcceptor";
    }

    public void addConnector(InternalConnector connector) {
        super.addConnector(connector);
        HTTPServerConnector httpConnector = (HTTPServerConnector)connector;
        this.httpConnectors.put(httpConnector.getConnectorID(), httpConnector);
    }

    public void removeConnector(IConnector connector) {
        HTTPConnector httpConnector = (HTTPConnector)connector;
        this.httpConnectors.remove(httpConnector.getConnectorID());
        super.removeConnector(connector);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.randomizer, "randomizer");
        this.checkState(this.connectorIDLength > 0, "Constraint violated: connectorIDLength > 0");
        this.checkState(this.maxIdleTime >= 100, "Constraint violated: maxIdleTime >= 100");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.cleaner.setDaemon(true);
        this.cleaner.activate();
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.cleaner, (OMLogger.Level)OMLogger.Level.WARN);
        super.doDeactivate();
    }

    protected String createConnectorID(String userID) {
        return this.randomizer.nextString(this.connectorIDLength, "0123456789ABCDEF");
    }

    protected HTTPServerConnector createServerConnector() {
        return new HTTPServerConnector(this);
    }

    protected int cleanIdleConnectors() {
        long now = System.currentTimeMillis();
        IConnector[] connectors = this.getAcceptedConnectors();
        if (TRACER.isEnabled()) {
            TRACER.format("Checking {0} HTTP server connectors for idle time: {1,time}", new Object[]{connectors.length, new Date()});
        }
        IConnector[] iConnectorArray = connectors;
        int n = connectors.length;
        int n2 = 0;
        while (n2 < n) {
            IConnector connector = iConnectorArray[n2];
            HTTPServerConnector serverConnector = (HTTPServerConnector)connector;
            long lastTraffic = serverConnector.getLastTraffic();
            long idleTime = now - lastTraffic;
            if (idleTime > (long)this.maxIdleTime) {
                serverConnector.deactivate();
                OM.LOG.info(String.valueOf(Messages.getString("HTTPAcceptor.8")) + (Object)((Object)serverConnector));
            }
            ++n2;
        }
        return this.maxIdleTime;
    }
}

