/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREsComboBlock;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class JavaJRETab
extends JavaLaunchTab {
    protected JREsComboBlock fJREBlock;
    protected ILaunchConfigurationTab fDynamicTab;
    protected Composite fDynamicTabHolder;
    protected boolean fUseDynamicArea = true;
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected ILaunchConfiguration fLaunchConfiguration;
    protected boolean fIsInitializing = false;
    private boolean fCurrentJREModular;
    private IPropertyChangeListener fCheckListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            JavaJRETab.this.handleSelectedJREChanged();
        }
    };

    public JavaJRETab() {
        this.setHelpContextId(IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_JRE_TAB);
    }

    public void dispose() {
        super.dispose();
        if (this.fJREBlock != null) {
            this.fJREBlock.removePropertyChangeListener(this.fCheckListener);
        }
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topComp = SWTFactory.createComposite((Composite)parent, (Font)font, (int)1, (int)1, (int)768, (int)0, (int)0);
        this.fJREBlock = new JREsComboBlock(true);
        this.fJREBlock.setDefaultJREDescriptor(this.getDefaultJREDescriptor());
        this.fJREBlock.setSpecificJREDescriptor(this.getSpecificJREDescriptor());
        this.fJREBlock.createControl(topComp);
        Control control = this.fJREBlock.getControl();
        this.fJREBlock.addPropertyChangeListener(this.fCheckListener);
        control.setLayoutData((Object)new GridData(768));
        this.setDynamicTabHolder(SWTFactory.createComposite((Composite)topComp, (Font)font, (int)1, (int)1, (int)1808, (int)0, (int)0));
        this.setControl((Control)topComp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    protected void setDynamicTabHolder(Composite tabHolder) {
        this.fDynamicTabHolder = tabHolder;
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTab(ILaunchConfigurationTab tab) {
        this.fDynamicTab = tab;
    }

    protected ILaunchConfigurationTab getDynamicTab() {
        return this.fDynamicTab;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.setLaunchConfigurationWorkingCopy(config);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.setDefaults(config);
        }
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fIsInitializing = true;
        this.getControl().setRedraw(false);
        this.setLaunchConfiguration(configuration);
        this.updateJREFromConfig(configuration);
        this.fJREBlock.setDefaultJREDescriptor(this.getDefaultJREDescriptor());
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.initializeFrom(configuration);
        }
        this.getControl().setRedraw(true);
        this.fIsInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fJREBlock.isDefaultJRE()) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
        } else {
            IPath containerPath = this.fJREBlock.getPath();
            String portablePath = null;
            if (containerPath != null) {
                portablePath = containerPath.toPortableString();
            }
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, portablePath);
        }
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab == null) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
        } else {
            dynamicTab.performApply(configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        IStatus status = this.fJREBlock.getStatus();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        if (!this.isExternalToolConfiguration(this.fLaunchConfiguration) && !(status = this.checkCompliance()).isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    private boolean isExternalToolConfiguration(ILaunchConfiguration configuration) {
        try {
            ILaunchConfigurationType type = configuration.getType();
            String id = type.getIdentifier();
            return id != null && (id.equals("org.eclipse.ant.AntLaunchConfigurationType") || id.equals("org.eclipse.ant.AntBuilderLaunchConfigurationType") || id.equals("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType") || id.equals("org.eclipse.ui.externaltools.ProgramBuilderLaunchConfigurationType"));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private IStatus checkCompliance() {
        IPath vmPath;
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return Status.OK_STATUS;
        }
        String source = LauncherMessages.JavaJRETab_3;
        String compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", false);
        if (compliance == null) {
            compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
            source = LauncherMessages.JavaJRETab_4;
        }
        if ((vmPath = this.fJREBlock.getPath()) != null) {
            int val;
            AbstractVMInstall install;
            String vmver;
            IVMInstall vm = null;
            if (JavaRuntime.newDefaultJREContainerPath().equals((Object)vmPath)) {
                if (javaProject.isOpen()) {
                    try {
                        vm = JavaRuntime.getVMInstall((IJavaProject)this.getJavaProject());
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                        return Status.OK_STATUS;
                    }
                    if (vm == null) {
                        vm = JavaRuntime.getVMInstall((IPath)vmPath);
                    }
                }
            } else {
                vm = JavaRuntime.getVMInstall((IPath)vmPath);
            }
            String environmentId = JavaRuntime.getExecutionEnvironmentId((IPath)vmPath);
            if (vm instanceof AbstractVMInstall && (vmver = (install = (AbstractVMInstall)vm).getJavaVersion()) != null && (val = compliance.compareTo(vmver)) > 0) {
                String setting = null;
                setting = environmentId == null ? LauncherMessages.JavaJRETab_2 : LauncherMessages.JavaJRETab_1;
                return new Status(4, IJavaDebugUIConstants.PLUGIN_ID, 4, NLS.bind((String)LauncherMessages.JavaJRETab_0, (Object[])new String[]{setting, source, compliance}), null);
            }
            return Status.OK_STATUS;
        }
        return this.fJREBlock.getStatus();
    }

    public String getName() {
        return LauncherMessages.JavaJRETab__JRE_1;
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
    }

    public String getId() {
        return "org.eclipse.jdt.debug.ui.javaJRETab";
    }

    protected void updateJREFromConfig(ILaunchConfiguration config) {
        try {
            String path = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
            if (path != null) {
                this.fJREBlock.setPath(Path.fromPortableString((String)path));
                return;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        String vmName = null;
        String vmTypeID = null;
        try {
            vmTypeID = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            vmName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.selectJRE(vmTypeID, vmName);
    }

    protected void handleSelectedJREChanged() {
        this.loadDynamicJREArea();
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (wc == null && this.getLaunchConfiguration().isWorkingCopy()) {
                wc = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (!this.fIsInitializing && wc != null) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
            }
        } else {
            if (wc == null) {
                try {
                    ILaunchConfiguration config = this.getLaunchConfiguration();
                    if (config.isWorkingCopy()) {
                        wc = (ILaunchConfigurationWorkingCopy)config;
                        if (wc.getOriginal() != null) {
                            wc.getOriginal().getWorkingCopy();
                        }
                    } else {
                        wc = this.getLaunchConfiguration().getWorkingCopy();
                    }
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    JDIDebugUIPlugin.statusDialog(status);
                    JDIDebugUIPlugin.log(status);
                    return;
                }
            }
            if (!this.fIsInitializing) {
                this.getDynamicTab().setDefaults(wc);
                this.getDynamicTab().initializeFrom((ILaunchConfiguration)wc);
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void selectJRE(String typeID, String vmName) {
        if (typeID == null || vmName == null) {
            this.fJREBlock.setPath(JavaRuntime.newDefaultJREContainerPath());
        } else {
            this.fJREBlock.setPath(JavaRuntime.newJREContainerPath((String)typeID, (String)vmName));
        }
    }

    protected ILaunchConfigurationTab getTabForCurrentJRE() {
        IVMInstall vm;
        IPath path;
        if (!this.fJREBlock.isDefaultJRE() && (path = this.fJREBlock.getPath()) != null && JavaRuntime.getExecutionEnvironmentId((IPath)path) == null && (vm = this.fJREBlock.getJRE()) != null) {
            String vmInstallTypeID = vm.getVMInstallType().getId();
            return JDIDebugUIPlugin.getDefault().getVMInstallTypePage(vmInstallTypeID);
        }
        return null;
    }

    protected void loadDynamicJREArea() {
        Control[] children = this.getDynamicTabHolder().getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        if (this.isUseDynamicJREArea()) {
            this.setDynamicTab(this.getTabForCurrentJRE());
            if (this.getDynamicTab() == null) {
                return;
            }
            this.getDynamicTab().setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
            this.getDynamicTab().createControl(this.getDynamicTabHolder());
            this.getDynamicTabHolder().layout();
        }
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    public String getErrorMessage() {
        ILaunchConfigurationTab tab = this.getDynamicTab();
        if (super.getErrorMessage() != null || tab == null) {
            return super.getErrorMessage();
        }
        return tab.getErrorMessage();
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
        try {
            JavaRuntime.getJavaProject((ILaunchConfiguration)launchConfiguration);
            this.fCurrentJREModular = JavaRuntime.isModularConfiguration((ILaunchConfiguration)this.getLaunchConfiguration());
        }
        catch (CoreException coreException) {
            this.fCurrentJREModular = false;
        }
    }

    public void setVMSpecificArgumentsVisible(boolean visible) {
        this.fUseDynamicArea = visible;
    }

    protected boolean isUseDynamicJREArea() {
        return this.fUseDynamicArea;
    }

    protected JREDescriptor getDefaultJREDescriptor() {
        return new JREDescriptor(){

            @Override
            public String getDescription() {
                IJavaProject project = JavaJRETab.this.getJavaProject();
                String name = LauncherMessages.JavaJRETab_7;
                if (project == null) {
                    IVMInstall vm = JavaRuntime.getDefaultVMInstall();
                    if (vm != null) {
                        name = vm.getName();
                    }
                    return NLS.bind((String)LauncherMessages.JavaJRETab_8, (Object[])new String[]{name});
                }
                try {
                    String eeName = null;
                    IClasspathEntry[] classpath = project.getRawClasspath();
                    int i = 0;
                    while (i < classpath.length) {
                        IExecutionEnvironment env;
                        String id;
                        IClasspathEntry entry = classpath[i];
                        if (entry.getEntryKind() == 5 && JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0)) && (id = JavaRuntime.getExecutionEnvironmentId((IPath)entry.getPath())) != null && (env = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(id)) != null) {
                            eeName = env.getId();
                            break;
                        }
                        ++i;
                    }
                    IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)project);
                    if (vm != null) {
                        name = vm.getName();
                    }
                    if (eeName != null) {
                        return NLS.bind((String)LauncherMessages.JavaJRETab_5, (Object[])new String[]{eeName, name});
                    }
                }
                catch (CoreException coreException) {}
                return NLS.bind((String)LauncherMessages.JavaJRETab_9, (Object[])new String[]{name});
            }
        };
    }

    protected JREDescriptor getSpecificJREDescriptor() {
        return null;
    }

    protected IJavaProject getJavaProject() {
        if (this.getLaunchConfiguration() != null) {
            try {
                IProject project;
                String name = this.getLaunchConfiguration().getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                if (name != null && name.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(name)).exists()) {
                    return JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fJREBlock.refresh();
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void postApply() {
        ILaunchConfigurationDialog dialog;
        boolean newJREModular = JavaRuntime.isModularConfiguration((ILaunchConfiguration)this.getLaunchConfiguration());
        if (this.fCurrentJREModular != newJREModular && (dialog = LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog()) instanceof LaunchConfigurationsDialog) {
            LaunchConfigurationTabGroupViewer tabViewer = ((LaunchConfigurationsDialog)dialog).getTabViewer();
            tabViewer.refreshTabs(true);
        }
    }

    public boolean OkToLeaveTab() {
        boolean newJREModular = JavaRuntime.isModularConfiguration((ILaunchConfiguration)this.getLaunchConfiguration());
        if (this.fCurrentJREModular != newJREModular) {
            return this.handleClasspathDependenciesChange(newJREModular);
        }
        return true;
    }

    private void handleConfiguraionDialog() {
        ILaunchConfigurationDialog dialog = LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog();
        if (dialog instanceof LaunchConfigurationsDialog) {
            LaunchConfigurationTabGroupViewer tabViewer = ((LaunchConfigurationsDialog)dialog).getTabViewer();
            tabViewer.handleApplyPressed();
            tabViewer.refreshTabs(false);
        }
    }

    private boolean handleClasspathDependenciesChange(boolean newJREModular) {
        String title = LauncherMessages.JavaJRETab_10;
        String message = LauncherMessages.JavaJRETab_11;
        String[] buttonLabels = new String[]{LauncherMessages.JavaJRETab_12, LauncherMessages.JavaJRETab_13};
        MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
        int res = dialog.open();
        if (res == 0) {
            this.fCurrentJREModular = newJREModular;
            this.handleConfiguraionDialog();
            return true;
        }
        return false;
    }
}

