/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.model.ModelMessages;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryLabelProvider;
import org.eclipse.swt.graphics.Image;

public final class JavaModelLabelProvider
extends AppearanceAwareLabelProvider {
    private static final String NAME_SETTINGS_FOLDER = ".settings";
    private final RefactoringHistoryLabelProvider fHistoryLabelProvider = new RefactoringHistoryLabelProvider(new RefactoringHistoryControlConfiguration(null, false, false));
    private final String fPreferencesLabel;
    private final String fRefactoringsLabel;
    private Image fSettingsImage = null;

    public JavaModelLabelProvider() {
        this(ModelMessages.JavaModelLabelProvider_project_preferences_label, ModelMessages.JavaModelLabelProvider_refactorings_label);
    }

    public JavaModelLabelProvider(String preferences, String refactorings) {
        super(36421324767273L, 3);
        Assert.isNotNull((Object)preferences);
        Assert.isNotNull((Object)refactorings);
        this.fPreferencesLabel = preferences;
        this.fRefactoringsLabel = refactorings;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fHistoryLabelProvider.dispose();
        if (this.fSettingsImage != null && !this.fSettingsImage.isDisposed()) {
            this.fSettingsImage.dispose();
            this.fSettingsImage = null;
        }
    }

    @Override
    public Image getImage(Object element) {
        Image image;
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            if (!JavaModelLabelProvider.isInJavaProject(folder)) {
                return null;
            }
            if (folder.getName().equals(NAME_SETTINGS_FOLDER)) {
                if (this.fSettingsImage == null || this.fSettingsImage.isDisposed()) {
                    this.fSettingsImage = JavaPluginImages.DESC_OBJS_PROJECT_SETTINGS.createImage();
                }
                return this.decorateImage(this.fSettingsImage, element);
            }
        }
        if ((image = super.getImage(element)) == null) {
            if (element instanceof RefactoringHistory) {
                image = this.fHistoryLabelProvider.getImage(element);
            } else if (element instanceof RefactoringDescriptorProxy) {
                image = this.fHistoryLabelProvider.getImage(element);
            }
            return this.decorateImage(image, element);
        }
        return image;
    }

    @Override
    public String getText(Object element) {
        String text;
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            if (!JavaModelLabelProvider.isInJavaProject(folder)) {
                return null;
            }
            if (folder.getName().equals(NAME_SETTINGS_FOLDER)) {
                return this.decorateText(this.fPreferencesLabel, element);
            }
        }
        if ((text = super.getText(element)) == null || "".equals(text)) {
            if (element instanceof RefactoringHistory) {
                text = this.fRefactoringsLabel;
            } else if (element instanceof RefactoringDescriptorProxy) {
                text = this.fHistoryLabelProvider.getText(element);
            }
            return this.decorateText(text, element);
        }
        return text;
    }

    private static boolean isInJavaProject(IFolder folder) {
        try {
            return folder.getProject().getNature("org.eclipse.jdt.core.javanature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

