/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.NewWizardMenu;

public class NewWizardsActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private NewWizardMenu fNewWizardMenu;

    public NewWizardsActionGroup(IWorkbenchSite site) {
        this.fSite = site;
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection && this.canEnable((IStructuredSelection)selection)) {
            MenuManager newMenu = new MenuManager(ActionMessages.NewWizardsActionGroup_new);
            menu.appendToGroup("group.new", (IContributionItem)newMenu);
            newMenu.add((IContributionItem)this.getNewWizardMenu());
        }
    }

    private NewWizardMenu getNewWizardMenu() {
        if (this.fNewWizardMenu == null) {
            this.fNewWizardMenu = new NewWizardMenu(this.fSite.getWorkbenchWindow());
        }
        return this.fNewWizardMenu;
    }

    private boolean canEnable(IStructuredSelection sel) {
        if (sel.size() == 0) {
            return true;
        }
        List list = sel.toList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (this.isNewTarget(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isNewTarget(Object element) {
        if (element == null) {
            return true;
        }
        if (element instanceof IResource) {
            return true;
        }
        if (element instanceof IJavaElement) {
            int type = ((IJavaElement)element).getElementType();
            return type == 2 || type == 3 || type == 4 || type == 5 || type == 7;
        }
        if (element instanceof IWorkingSet) {
            String workingSetId = ((IWorkingSet)element).getId();
            return "org.eclipse.jdt.ui.JavaWorkingSetPage".equals(workingSetId) || "org.eclipse.ui.resourceWorkingSetPage".equals(workingSetId) || "org.eclipse.jdt.internal.ui.OthersWorkingSet".equals(workingSetId);
        }
        return false;
    }

    public void dispose() {
        if (this.fNewWizardMenu != null) {
            this.fNewWizardMenu.dispose();
            this.fNewWizardMenu = null;
        }
        super.dispose();
    }
}

